<style>
.input-group 
{
	height: 46px;
}
.bg-c
{
	background: #E44F26;
	color: #fff;
	font-weight: bold;
}
.bg-c:hover
{
	color: #fff;
}

.select2-container--default .select2-selection--single {
    border: 0px solid #ced4da;
    border-radius: 0px !important;
    height: 32px;
}

.select2-container--default .select2-selection--single {
     background-color: #e44f26; 
    border: 0px solid #aaa;
    border-radius: 4px;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 29px;
    color: #fff;
    background: #e44f26;

}

.select2-container--default .select2-selection--single .select2-selection__arrow b {
    border-color: #fff transparent transparent transparent;
    border-style: solid;
    border-width: 5px 4px 0 4px;
    height: 0;
    left: 50%;
    margin-left: -4px;
    margin-top: -6px;
    position: absolute;
    top: 50%;
    width: 0;
}


.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 29px;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #fff;
    font-size: 18px;
    /* line-height: 28px; */
}

</style>


<div class="row">
	<div class="col-md-12 mb-3">
		<div class="site_heading">
			<h3>Hard Floor Calculator</h3>
		</div>
	</div>
	<div class="col-md-12 p-3 pb-0 bg-light mb-0">
		<div class="row">



			<div class="col-md-12 px-4 p-2">
				<div class="row">


					<div class="col-4 mb-3">
						<label class="form-label fs-4">Width <span class="fs-4" id="b_livem2"> </span></label>
						<div class="input-group mb-3">
						  <input type="number" id="b_value" class="form-control" placeholder="" >
						  <span class="input-group-text  bg-c " id="basic-addon2">
						  	<select class="form-select" id="b_select">
						  		<option value="foot" >ft</option>
						  		<option value="inch">Inch</option>
						  		<option value="mm">mm</option>
						  		<option value="cm">cm</option>
						  		<option value="m" selected>m</option>
						  	</select>
						  </span>
						</div>
					</div>

					<div class="col-1 pt-5 text-center">
						<span class="mt-2 d-block">X</span>
					</div>

					<div class="col-4 mb-3">
						<label class="form-label fs-4">Length <span class="fs-4" id="l_livem2"> </span></label>
						<div class="input-group mb-3">
						  <input type="number" id="l_value" class="form-control" placeholder="" >
						  <span class="input-group-text  bg-c " id="basic-addon2">
						  	<select class="form-select " id="l_select">
						  		<option value="foot" >ft</option>
						  		<option value="inch">Inch</option>
						  		<option value="mm">mm</option>
						  		<option value="cm">cm</option>
						  		<option value="m" selected>m</option>
						  	</select>
						  </span>
						</div>
					</div>  
					<div class="col-3 mb-3">
						<label class="form-label fs-4">Actual Area (m<sup>2</sup>)</label>
						<div class="input-group mb-3">
						  <input type="text" id="result" style="color:green; font-weight: bold; font-size: 22px;" class="form-control bg-white" disabled >
						  <!-- <span class="input-group-text" id="basic-addon2">m<sup>2</sup></span> -->
						</div>

						<br>
						<button id='calculator' class="btn float-end bg-c btn-lg rounded-0">CALCULATE</button>
					</div>

				</div>
			</div>


			
		</div>
	</div>
</div>




<script>



//  1ft = 0.092903 m2;

// b_livem2


$('#b_value').keyup(function(){
	bmatrix();
});

$('#b_select').change(function(){
	bmatrix();
});




$('#l_value').keyup(function(){
	lmatrix();
});
$('#l_select').change(function(){
	lmatrix();
});



function  bmatrix()
{
	const w_val = $('#b_value').val();
	const selectVal = $('#b_select').val();
	if(selectVal == 'inch')
	{
		const inch1 = 0.0254;
		$('#b_livem2').html(parseFloat(w_val * inch1).toFixed(2) + ' m');
	}else if(selectVal == 'mm')
	{
		const mm1 = 0.001;
		$('#b_livem2').html(parseFloat(w_val * mm1).toFixed(2) + ' m');
	}else if(selectVal == 'cm')
	{
		const cm1 = 0.01;
		$('#b_livem2').html(parseFloat(w_val * cm1).toFixed(2) + ' m');
	}else if(selectVal == 'm')
	{
		const m1 = 1;
		$('#b_livem2').html(parseFloat(w_val * m1).toFixed(2) + ' m');
	}else if(selectVal == 'foot')
	{
		const ft1 = 0.3048;
		$('#b_livem2').html(parseFloat(w_val * ft1).toFixed(2) + ' m');
	}
}

function  lmatrix()
{
	const l_val = $('#l_value').val();

	const selectVal = $('#l_select').val();

	if(selectVal == 'inch')
	{
		const inch1 = 0.0254;
		$('#l_livem2').html(parseFloat(l_val * inch1).toFixed(2) + ' m');
	}else if(selectVal == 'mm')
	{
		const mm1 = 0.001;
		$('#l_livem2').html(parseFloat(l_val * mm1).toFixed(2) + ' m');
	}else if(selectVal == 'cm')
	{
		const cm1 = 0.01;
		$('#l_livem2').html(parseFloat(l_val * cm1).toFixed(2) + ' m');
	}else if(selectVal == 'm')
	{
		const m1 = 1;
		$('#l_livem2').html(parseFloat(l_val * m1).toFixed(2) + ' m');
	}else if(selectVal == 'foot')
	{
		const ft1 = 0.3048;
		$('#l_livem2').html(parseFloat(l_val * ft1).toFixed(2) + ' m');
	}
}


// $('#b_value').keyup(function(){
// 	const w_val = $(this).val();
// 	const ft1 = 0.3048;
// 	$('#b_livem2').html(parseFloat(w_val * ft1).toFixed(2) + ' m');

// });

// $('#l_value').keyup(function(){
// 	const l_val = $(this).val();
// 	const ft1 = 0.3048;
// 	$('#l_livem2').html( parseFloat(l_val * ft1).toFixed(2) + ' m');

// });



$(document).ready(function(){
	$('#calculator').click(function(){
		const lvalue = $('#l_value').val();
		const lselect = $('#l_select').val();
		const bvalue = $('#b_value').val();
		const bselect = $('#b_select').val();
		const firstm =  convertBase(lselect, lvalue);
		const secondm =  convertBase(bselect, bvalue);
		const area = firstm*secondm;
		if(area)
		{
			$('#result').val(parseFloat(area).toFixed(2));
		}
	});
	function convertBase(selectVal, value)
	{
		if(selectVal == 'inch')
		{
			return value * 0.0254;
		}else if(selectVal == 'mm')
		{
			return value * 0.001;
		}else if(selectVal == 'cm')
		{
			return value * 0.01;
		}else if(selectVal == 'm')
		{
			return value * 1;
		}else if(selectVal == 'foot')
		{
			return value * 0.3048;
		}
	}
});


</script>



