<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<!-- <meta name="viewport" content="width=device-width, initial-scale=1"> -->
	<title>Quotation</title>
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style type="text/css">
	
.print-header
{
	background: #373737;
}
.clear-float
{
	clear: both;
}
.border-bottoms
{
	border-bottom: 1px solid #bd9e8b;
}
.border-right
{
	border-right: 2px solid #c16d2f;
}
.border-shadow
{
	border: 1px solid #c0aea2;
}

.ctr
{
	background: #fbfbfb;
	margin-bottom: 10px;
	border-bottom: 10px solid #fff;
}

p
{
	font-size: 14px;
	margin-bottom: 0px;
}
textarea, span
{
	font-size: 13px;
	margin-bottom: 0px;
}
.w-td
{
	min-width: 180px;
	display: inline-block;
}

.green-bg
{
	background: #538234;
	width: 100%;
	text-align: center;
	font-size: 30px;
	font-weight: 600;
	color: #fff;
	padding: 40px 0px;
}
.cart_table
{
	font-size: 10px;
}

td, th
{
	font-size: 13px;
}
trgroup
{
	border: 2px solid red;
}

tr.ctr
{
	border-top: 2px solid green;
}
.cal_table_parent td, .cal_table_parent th
{
	font-size: 11px !important;
}
</style>

</head>
<body>

<?php 

$custData = getAdminDataByID($details->o_cust_id);
										

 ?>

<section class="bg-dark" style="min-height: 100vh;">
	<div class="container">
		<div class="row justify-content-evenly">
			<div class="col-md-8 bg-white px-0" style="min-height: 100vh;">
				
				<header class="print-header py-5 px-4">
					<h1 class="float-start " style="color: #c49f6b;">Quotation</h1>
					<img src="<?= site_url('front/img/print-logo.png') ?>" class="float-end" width="200px">
					<div class="clear-float"></div>
				</header>

				<div class="text-center py-4 border-bottoms">
					<p>24, Nottingham Road, Loughborough, Leicestershire LE11 1EU | Tel: 01509 267 413</p>
				</div>

				<div class="py-3 px-4 border-bottoms">
					<div class="row">
						<div class="col-8 py-4 pt-4">
							<div class="row mt-1">
								<div class="col-6 pe-0">
									<span class="border-shadow p-3 py-2 d-block p-4 " >Invoice To: <?=  $custData->ac_fname.' '.$custData->ac_mname.' '.$custData->ac_lname; ?> <br> <?= $custData->ac_street_address; ?> <br>  <?= $custData->ac_zip; ?></span>
								</div>
								<div class="col-6 ps-1 pt-0">
									<span class="border-shadow px-1 py-1 mt-0 d-block">Quote Date: <?= date('d/m/Y', strtotime($details->o_created_at)) ?></span>
									<span class="border-shadow px-1 py-1 my-1 d-block">Valid Until: N.I.</span>
									<span class="border-shadow px-1 py-1  d-block">Quote Number: <?= $details->o_id; ?></span>
								</div>
							</div>
						</div>
						<div class="col-4">
							<div class="green-bg">
								ACCEPT QUOTE
							</div>
						</div>
					</div>
				</div>


				<div class="py-3 px-4 ">
					<table class="table table-borderless">
						<thead>
							<tr>
								<th width="300">Description</th>
								<th>Rate/Price m<sup>2</sup></th>
								<th>Qty</th>
								<th>Line Total</th>
							</tr>
						</thead>
						<tbody>

							<?php foreach($list as $ls){
							
							   $catDatas = getProductCategory($ls->pro_id);
							   
							?>

							<tr class="ctr">
							    
							    <?php if($catDatas->cwf_cat_id == "170"){ 
							         $mainIMg2 = getProductImageByID($ls->pro_main_image);
							    ?>
							    <td class="border-right"> 
							       <div class="d-flex">
							            <?php if($mainIMg2){ ?>
							            <img src="<?= SITE_MEDIA ?>uploads/images/product-images/<?= $ls->pro_id ?>/<?= $mainIMg2->cwfpi_image; ?>" width="50px" class="me-3 mt-2">
							        <?php }else{ ?>
							            <img src="<?= SITE_MEDIA ?>front/img/no-img.jpeg" width="120px">
							        <?php } ?>
							        <div>
							            <?= $ls->pro_title ?>
							            
    									<br>
							        </div>
							       </div>
							    
								</td>
							    <?php }else{ ?>
								<td class="border-right"><?= $ls->pro_title ?> <br>
									<b>Colour Code:</b> <?= $ls->oci_sku_code ?>
									<br>
								</td>
								<?php } ?>
								
								<?php if($catDatas->cwf_cat_id == "170"){ ?>
								    <td  class="border-right"><?= currency_filter($ls->oci_total_price) ?></td>
								<?php }else{ ?>
								    <td  class="border-right"><?= currency_filter($ls->oci_total_price/$ls->oci_prod_qty) ?></td>
								<?php } ?>
								
								
								
								
								
								
								<td  class="border-right"><?= $ls->oci_prod_qty ?></td>
								<?php if($catDatas->cwf_cat_id == "170"){ ?>
								    <td><?= currency_filter($ls->oci_total_price*$ls->oci_prod_qty) ?></td>
								<?php }else{ ?>
								    <td><?= currency_filter($ls->oci_total_price) ?></td>
								<?php } ?>
								
							</tr>

							
					 			<tr>
									<td class="cart_table py-2" colspan="4">
										<?php $cartCalRows = cartCalData($ls->oci_cart_old_id); 
										if($cartCalRows){
									 ?>
									 	<div class="row">
									 		<div class="col-md-3 text-center ">

									 			<?php $mainIMg = getProductImageBySKUID($ls->oci_sku_code);
													if($mainIMg){ ?>
													<img src="<?= SITE_MEDIA ?>uploads/images/product-images/<?= $ls->pro_id ?>/<?= $mainIMg->cwfpi_image; ?>" width="100%">
												<?php }else{ ?>
													<img src="<?= SITE_MEDIA ?>front/img/no-img.jpeg" width="100%">
												<?php } ?>
										 		
										 	</div>
											<div class="col-md-9 ">




<?php if($ls->cwf_cat_parent_id == '8'){ ?>
	<!-- Hard Floor -->
<table class="cal_table_parent table table-bordered table-responsive">
	<thead>
		<tr>
			<th>Room Type</th>
			<th>Width</th>
			<th>Length</th>
			<th>Actual Area</th>
			<th>Order Size Area</th>
			<th>Price</th>
			<th>Box Qty</th>
		</tr>
	</thead>
	<tbody>
	<?php
	$total_order_size_area = [];
		foreach($cartCalRows as $cR){ 
			array_push($total_order_size_area, $cR->cd_order_size_area);
		?>
		<tr>
			<td><?= $cR->cd_room_type ?></td>
			<td><?= $cR->cd_width ?> <?= $cR->cd_units ?></td>
			<td><?= $cR->cd_length ?> <?= $cR->cd_units ?></td>
			<td><?= $cR->cd_actual_area ?></td>
			<td><?= $cR->cd_order_size_area ?></td>
			<td><?= $cR->cd_price ?></td>
			<td><?= $cR->cd_box_count ?></td>
		</tr>
	<?php } ?>
		<tr>
			<td colspan="5"></td>
			<td colspan="3">
				<?= currency_filter(array_sum($total_order_size_area)) ?> m2
			</td>
		</tr>

	</tbody>
</table>

<?php }else{ ?>


<table class="cal_table_parent table table-bordered table-responsive">
	<thead>
		<tr>
			<th>Room Type</th>
			<th>Width</th>
			<th>Length</th>
			<th>Actual Area</th>
			<th>Order Size Area</th>
			<th>Price</th>
			<th>Recommended<br>
				W x L x qty = Area and Price
			</th>
		</tr>
	</thead>
	<tbody>
	<?php
	$total_order_size_area = [];
		foreach($cartCalRows as $cR){ 
			array_push($total_order_size_area, $cR->cd_order_size_area);
		?>
		<tr>
			<td><?= $cR->cd_room_type ?></td>
			<td><?= $cR->cd_width ?> <?= $cR->cd_units ?></td>
			<td><?= $cR->cd_length ?> <?= $cR->cd_units ?></td>
			<td><?= $cR->cd_actual_area ?></td>
			<td><?= $cR->cd_order_size_area ?></td>
			<td ><?= $cR->cd_price ?></td>
			<td width="200">
				<?php 
					if(!empty($cR->cd_options_json)){
						$json_data = json_decode($cR->cd_options_json);

						$x = 1;
						foreach($json_data as $jd){
							if($x < count($json_data))
							{
								echo $jd->width.' x '.$jd->length.' x '.$jd->qty.' = '.$jd->total_area.' m<sup>2</sup> and '.$jd->total_price."<hr>";
							}else
							{
								echo $jd->width.' x '.$jd->length.' x '.$jd->qty.' = '.$jd->total_area.' m<sup>2</sup> and '.$jd->total_price;
							}
							

						$x++;

						}
					} 
				?>


			</td>
		</tr>
	<?php } ?>
		<tr>
			<td colspan="5"></td>
			<td colspan="3">
				<?= currency_filter(array_sum($total_order_size_area)) ?> m2
			</td>
		</tr>

	</tbody>
</table>


<?php } ?>














											</div>
									 	</div>
									
									<?php } ?>
									</td>
								</tr>
							<?php } ?>


							
							<tr class="ctr">
								<td >
									
								</td>
								<td colspan="2">
									<span class="border-shadow p-3 py-1 mt-2 float-end" >Subtotal</span>
									<div class="clear-float"></div>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >Discount Amount %</span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >Discounted Sub Total</span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >VAT</span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >Amount To Pay</span>
								</td>
								<td>
									<span class="border-shadow p-3 py-1 mt-2 d-block" ><?= currency_filter($details->o_total) ?></span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >
										<?= 

										currency_filter( ($details->o_discount_amount/$details->o_total) * 100);


										 ?> %
									</span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" ><?= currency_filter($details->o_total - $details->o_discount_amount) ?></span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >N.I.</span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >£ N.I.</span>
								</td>
							</tr>
							
						</tbody>
					</table>
				</div>

			</div>
		</div>
	</div>
</section>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/js/bootstrap.bundle.min.js" ></script>
<script type="text/javascript">
    function replaceRecursively(element, from, to) {
    if (element.childNodes.length) {
        element.childNodes.forEach(child => replaceRecursively(child, from, to));
    } else {
        const cont = element.textContent;
        if (cont) element.textContent = cont.replace(from, to);
    }
};



replaceRecursively(document.body, new RegExp("m2", "g"), "m²");

</script>

</body>
</html>