<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class UnitsController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('cwf_units');
        $data['list'] = $db->where('cwf_units_active','1')->orderby('cwf_units_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/units/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Cwf/units/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_units');

           
            $results = $db->where('cwf_units_name', $data['title'])->where('cwf_units_code', $data['code'])->where('cwf_units_active','1')->get()->getResult();
            $results_count = $db->get()->getResult();

            if($results)
            {
                session()->setFlashdata("error", "Data Not Unique");
                return $this->response->redirect(current_url());
            }

            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
            }

        $save_data = array(
                            'cwf_units_hash'=> createHash(),
                            'cwf_units_name'=> $data['title'],
                            'cwf_units_code'=> $data['code'],
                            'cwf_units_order' => count($results_count) + 1 ,
                            'cwf_units_status' => $data['status'],
                            'cwf_units_active' => '1',
                            'cwf_units_created_at' => date("Y-m-d h:i:s"),
                            'cwf_units_created_ip' => $this->request->getIPAddress(),
                            'cwf_units_created_id' => dsession_id(),
                            'cwf_units_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_units_updated_id' => dsession_id(),
                            'cwf_units_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Operation SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Operation Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = \Config\Database::connect()->table('cwf_units');
        $data['cat_data'] = (array) $db->where('cwf_units_active','1')->where('cwf_units_hash', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Cwf/units/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_units');


        $save_data = array(
                            'cwf_units_name'=> $data['title'],
                            'cwf_units_code'=> $data['code'],
                            'cwf_units_status' => $data['status'],
                            'cwf_units_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_units_updated_id' => dsession_id(),
                            'cwf_units_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('cwf_units_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Operation SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Operation Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

