<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class ShadesController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('cwf_color_shades');
        $data['list'] = $db->where('cwfc_active','A')->orderby('cwfc_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/shades/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Cwf/shades/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_color_shades');



            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $db->where('cwfc_name', $data['title'])->get()->getResult();
            $results_count = $db->get()->getResult();
            $results2 = $db->where('cwfc_code', $data['color'])->get()->getResult();
            
            if($results OR $results2)
            {
                session()->setFlashdata("error", "Color Not Unique");
                return $this->response->redirect(current_url());
            }

        
        if($_FILES['file']['name'])
        {  
            // Image
            $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[file,image/jpg,image/jpeg,image/gif,image/png,image/webp]',
                    // 'max_size[file,1024]',
                ],
            ]);
            if(!$validated) {
                session()->setFlashdata("error", "Please Upload Valid File");
                return $this->response->redirect(current_url()); 
            }

            $avatar = $this->request->getFile('file');
            $newName = $avatar->getRandomName();
            $avatar->move('./uploads/color-images/', $newName);
        }else
        {
            $newName = '';
        }



        $save_data = array(
                            'cwfc_hash'=> createHash(),
                            'cwfc_name'=> $data['title'],
                            'cwfc_image' => $newName,
                            'cwfc_code' => $data['color'],
                            'cwfc_order' => count($results_count) + 1 ,
                            'cwfc_status' => $data['status'],
                            'cwfc_active' => 'A',
                            'cwfc_created_at' => date("Y-m-d h:i:s"),
                            'cwfc_created_ip' => $this->request->getIPAddress(),
                            'cwfc_created_id' => dsession_id(),
                            'cwfc_updated_ip'  => $this->request->getIPAddress(),
                            'cwfc_updated_id' => dsession_id(),
                            'cwfc_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = \Config\Database::connect()->table('cwf_color_shades');
        $data['cat_data'] = (array) $db->where('cwfc_active','A')->where('cwfc_hash', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Cwf/shades/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_color_shades');

        if($_FILES['file']['name'])
        {  
            // Image
            $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[file,image/jpg,image/jpeg,image/gif,image/png,image/webp]',
                    // 'max_size[file,1024]',
                ],
            ]);
            if(!$validated) {
                session()->setFlashdata("error", "Please Upload Valid File");
                return $this->response->redirect(current_url()); 
            }

            $avatar = $this->request->getFile('file');
            $newName = $avatar->getRandomName();
            $avatar->move('./uploads/color-images/', $newName);
        }else
        {
            $newName = '';
        }

        $save_data = array(
                            'cwfc_name'=> $data['title'],
                            'cwfc_code' => $data['color'],
                            'cwfc_status' => $data['status'],
                            'cwfc_updated_ip'  => $this->request->getIPAddress(),
                            'cwfc_updated_id' => dsession_id(),
                            'cwfc_updated_at' => date("Y-m-d h:i:s"),
                        );
        
        if($newName)
        {
            $save_data['cwfc_image'] = $newName;
        }

        if($db->where('cwfc_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}


?>


