<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class ProductController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        $section = $this->request->getGet('section');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                if($section == 'basic')
                {
                    $this->edit();
                }elseif($section == 'features')
                {
                    $this->featuresEdit();
                }elseif($section == 'dimensions')
                {
                    $this->dimensionsEdit();
                }elseif($section == 'technical-information')
                {
                    $this->technicalInfo();
                }elseif($section == 'color')
                {
                    $this->colorEdit();
                }elseif($section == 'images')
                {
                    $this->imagesEdit();
                }elseif($section == 'filters')
                {
                    $this->filterEdit();
                }elseif($section == 'sku')
                {
                    $this->skuEdit();
                }elseif($section == 'variant')
                {
                    $this->variantEdit();
                }elseif($section == 'price')
                {
                    $this->priceEdit();
                }elseif($section == 'seo')
                {
                    $this->seoEdit();
                }elseif($section == 'other')
                {
                    $this->otherEdit();
                }elseif($section == 'status')
                {
                    $this->statusEdit();
                }elseif($section == 'accessories')
                {
                    $this->accessoriesEdit();
                }else
                {
                    $this->edit();
                    // return $this->response->redirect(site_url());
                }
                
            }elseif($action == 'editconf'){
                if($section == 'basic')
                {
                    $this->edit();
                }elseif($section == 'features')
                {
                    $this->featuresEditView();
                }elseif($section == 'dimensions')
                {
                    $this->dimensionsEditView();
                }elseif($section == 'technical-information')
                {
                    $this->technicalInfoEditView();
                }elseif($section == 'color')
                {
                    $this->colorEditView();
                }elseif($section == 'images')
                {
                    $this->imagesEditView();
                }elseif($section == 'filters')
                {
                    $this->filtersEditView();
                }elseif($section == 'sku')
                {
                    $this->skuEditView();
                }elseif($section == 'variant')
                {
                    $this->variantEditView();
                }elseif($section == 'price')
                {
                    $this->priceEdit();
                }elseif($section == 'seo')
                {
                    $this->seoEdit();
                }elseif($section == 'status')
                {
                    $this->statusEdit();
                }elseif($section == 'accessories')
                {
                    $this->accessoriesEditView();
                }else
                {
                    $this->edit();
                    // return $this->response->redirect(site_url());
                }
                
            }else
            {

                
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        $section = $this->request->getGet('section');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();

                if(!isset($_GET['type']))
                {
                    $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                }else
                {
                    $custome_data  = [];
                }
                    


                if($section == 'basic')
                {
                    $this->edit_conf($postData, $custome_data);
                }elseif($section == 'features')
                {
                    if(isset($_GET['type']) AND $_GET['type'] == 'add')
                    {
                        $this->featuresAddconf($postData, $custome_data);
                    }else{
                        $this->featuresEditConf($postData, $custome_data);
                    }
                }elseif($section == 'dimensions')
                {
                    if(isset($_GET['type']) AND $_GET['type'] == 'add')
                    {
                        $this->dimensionsAddconf($postData, $custome_data);
                    }else{
                        $this->dimensionsEditConf($postData, $custome_data);
                    }
                }elseif($section == 'technical-information')
                {
                    if(isset($_GET['type']) AND $_GET['type'] == 'add')
                    {
                        $this->technicalInfoAddconf($postData, $custome_data);
                    }else{
                        $this->technicalInfoEditConf($postData, $custome_data);
                    }
                }elseif($section == 'color')
                {
                    if(isset($_GET['type']) AND $_GET['type'] == 'add')
                    {
                        $this->colorAddconf($postData, $custome_data);
                    }else{
                        $this->colorEditconf($postData, $custome_data);
                    }
                    
                }elseif($section == 'images')
                {
                    if(isset($_GET['type']) AND $_GET['type'] == 'add')
                    {
                        $this->imageAddconf($postData, $custome_data);
                    }else{
                        $this->imagesEditconf($postData, $custome_data);
                    }

                }elseif($section == 'filters')
                {
                    if(isset($_GET['type']) AND $_GET['type'] == 'add')
                    {
                        $this->filterAddconf($postData, $custome_data);
                    }else{
                        $this->filterEditconf($postData, $custome_data);
                    }
                }elseif($section == 'sku')
                {
                    if(isset($_GET['type']) AND $_GET['type'] == 'add')
                    {
                        $this->skuAddconf($postData, $custome_data);
                    }else{
                        $this->skuEditconf($postData, $custome_data);
                    }
                }elseif($section == 'variant')
                {
                    if(isset($_GET['type']) AND $_GET['type'] == 'add')
                    {
                        $this->variantAddConf($postData, $custome_data);
                    }else{
                        $this->variantEditConf($postData, $custome_data);
                    }
                    
                }elseif($section == 'price')
                {
                    $this->priceEdit();
                }elseif($section == 'seo')
                {
                    $this->seoEditConf($postData, $custome_data);
                }elseif($section == 'status')
                {
                    $this->statusEditConf($postData, $custome_data);
                }elseif($section == 'other')
                {
                    
                    $this->otherEditConf($postData, $custome_data);
                }elseif($section == 'accessories')
                {
                    if(isset($_GET['type']) AND $_GET['type'] == 'add')
                    {
                        $this->accessoriesAddconf($postData, $custome_data);
                    }else{
                        $this->accessoriesEditconf($postData, $custome_data);
                    }
                    
                }else
                {
                    $this->edit();
                    // return $this->response->redirect(site_url());
                }


                
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {


        $db = \Config\Database::connect()->table('cwf_products');
        $data['list'] = $db->where('pro_active','A')->orderby('pro_ordering', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/product/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $db = dbconnect('cwf_prod_tags');
        $data['tag_list'] = $db->where('cwfpt_active','A')->where('cwfpt_status','A')->orderby('cwfpt_order', 'ASC')->get()->getResult();

        $db = \Config\Database::connect()->table('cwf_color_shades');
        $data['shades_list'] = $db->where('cwfc_active','A')->where('cwfc_status','A')->orderby('cwfc_order', 'ASC')->get()->getResult();


        $db = dbconnect('cwf_category');
        $data['cat_list'] = $db->where('cwf_cat_active','A')->where('cwf_cat_status','A')->orderby('cwf_cat_order', 'ASC')->where('cwf_cat_parent_id', Null)->get()->getResult();

        $db = \Config\Database::connect()->table('cwf_attribute_category');
        $data['attr_cat_list'] = $db->where('cwf_attr_cat_active','A')->where('cwf_attr_cat_status','A')->orderby('cwf_attr_cat_order', 'ASC')->get()->getResult();

        $db = \Config\Database::connect()->table('cwf_collections');
        $data['coll_list'] = $db->where('cwf_coll_active','A')->where('cwf_coll_status','A')->orderby('cwf_coll_order', 'ASC')->get()->getResult();

        // echo "<pre>";
        // print_r($data['coll_list']);
        // echo "</pre>";
        // exit();
        
         $db = \Config\Database::connect()->table('cwf_suppliers');
        $data['supplier_list'] = $db->join('admin_accounts', 'sup_ac_id = admin_accounts.ac_id')->where('ac_active','A')->where('ac_status', 'A')->join('account_type', 'ac_type = account_type.at_id')->where('at_code', 'S')->get()->getResult();
        
        if(isset($_GET['page']))
        {
            if($_GET['page'] == 'banner-images')
            {
                $db = dbconnect('cwf_pro_banner_images');
                $datas['list'] = $db->where('cwfpbi_active','A')->where('cwfpbi_pro_id', $_GET['id'])->orderby('cwfpbi_order', 'ASC')->get()->getResult();
                echo view('Admin/include/header');
                echo view('Cwf/product/pro-banner-images', $datas);
                echo view('Admin/include/footer');
            }else
            {

            }
        }else
        {
            echo view('Admin/include/header');
            echo view('Cwf/product/add', $data);
            echo view('Admin/include/footer');
        }
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = dbconnect('cwf_products');
            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $slug = str_replace('-----------','-', $slug);
            $slug = str_replace('----------','-', $slug);
            $slug = str_replace('---------','-', $slug);
            $slug = str_replace('--------','-', $slug);
            $slug = str_replace('-------','-', $slug);
            $slug = str_replace('------','-', $slug);
            $slug = str_replace('-----','-', $slug);
            $slug = str_replace('----','-', $slug);
            $slug = str_replace('---','-', $slug);
            $slug = str_replace('--','-', $slug);
            $results = $db->where('pro_title', $data['title'])->get()->getResult();
            $results_count = $db->get()->getResult();
            
            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $slug = $slug.'-'.$count_result;
            }

            $current_time = getdate();
            $pro_sku_code = $current_time['0'];
            $hash_key =  createHash();
            $save_data = array(
                            'pro_hash'=> $hash_key ,
                            'pro_title'=> $data['title'],
                            'pro_slug'=> $slug,
                            'pro_subtitle' => $data['sub_title'],
                            'pro_category' => $data['parent_category'],
                            'pro_descriptions' => $data['description'],
                            'pro_cf_sku_code' => $pro_sku_code,
                            'pro_supplier' => $data['supplier'],
                            'pro_supplier_sku_code' => $data['supplier_sku_code'],
                            'pro_ordering' => count($results_count) + 1 ,
                            'pro_status' => 'D',
                            'pro_active' => 'A',
                            'pro_created_at' => date("Y-m-d h:i:s"),
                            'pro_created_ip' => $this->request->getIPAddress(),
                            'pro_created_id' => dsession_id(),
                            'pro_updated_ip'  => $this->request->getIPAddress(),
                            'pro_updated_id' => dsession_id(),
                            'pro_updated_at' => date("Y-m-d h:i:s"),
                        );


                        
        if(isset($data['collections']))
        {
            $save_data['pro_collections'] = implode(',',$data['collections']);
        }
        if(isset($data['product_tag']))
        {
            $save_data['pro_tag'] = $data['product_tag'];
        }
        if(isset($data['attr_category']))
        {
            $save_data['pro_attr_category'] = implode(',',$data['attr_category']);
        }

        if(isset($data['shades']))
        {
            $save_data['pro_shades'] = implode(',',$data['shades']);
        }


        if($db->insert($save_data))
        {   
            $inserted_data = $db->where('pro_hash', $hash_key)->get()->getRow();

            session()->setFlashdata("success", "Product added to DB successfully");
            return $this->response->redirect(current_url().'?action=edit&section=features&product_id='.$inserted_data->pro_id);
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');
        $db = \Config\Database::connect()->table('cwf_products');
        $data['details'] =  $db->where('pro_active  ','A')->where('pro_hash', $token)->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();

        // echo "<pre>";
        // print_r($data);
        // exit();

        // 
        
        $db = \Config\Database::connect()->table('cwf_color_shades');
        $data['shades_list'] = $db->where('cwfc_active','A')->where('cwfc_status','A')->orderby('cwfc_order', 'ASC')->get()->getResult();

        $db = dbconnect('cwf_prod_tags');
        $data['tag_list'] = $db->where('cwfpt_active','A')->where('cwfpt_status','A')->orderby('cwfpt_order', 'ASC')->get()->getResult();

        

        $db = dbconnect('cwf_category');
        $data['cat_list'] = $db->where('cwf_cat_active','A')->where('cwf_cat_status','A')->orderby('cwf_cat_order', 'ASC')->where('cwf_cat_parent_id', Null)->get()->getResult();

        $db = dbconnect('cwf_category');
        $data['sub_cat_list'] = $db->where('cwf_cat_active','A')->where('cwf_cat_status','A')->orderby('cwf_cat_order', 'ASC')->where('cwf_cat_parent_id', $data['details']->cwf_cat_parent_id)->get()->getResult();

        $db = \Config\Database::connect()->table('cwf_attribute_category');
        $data['attr_cat_list'] = $db->where('cwf_attr_cat_active','A')->where('cwf_attr_cat_status','A')->orderby('cwf_attr_cat_order', 'ASC')->get()->getResult();

        $db = \Config\Database::connect()->table('cwf_collections');
        $data['coll_list'] = $db->where('cwf_coll_active','A')->where('cwf_coll_status','A')->orderby('cwf_coll_order', 'ASC')->get()->getResult();

       
        
         $db = \Config\Database::connect()->table('cwf_suppliers');
        $data['supplier_list'] = $db->join('admin_accounts', 'sup_ac_id = admin_accounts.ac_id')->where('ac_active','A')->where('ac_status', 'A')->join('account_type', 'ac_type = account_type.at_id')->where('at_code', 'S')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Cwf/product/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {



        $db = \Config\Database::connect()->table('cwf_products');
        $save_data = array(
                            'pro_title'=> $data['title'],
                            'pro_subtitle' => $data['sub_title'],
                            'pro_category' => $data['parent_category'],
                            'pro_descriptions' => $data['description'],
                            'pro_supplier' => $data['supplier'],
                            'pro_supplier_sku_code' => $data['supplier_sku_code'],
                            'pro_status' => $data['status'],
                            'pro_updated_ip'  => $this->request->getIPAddress(),
                            'pro_updated_id' => dsession_id(),
                            'pro_updated_at' => date("Y-m-d h:i:s"),
                        );
                        
        if(isset($data['collections']))
        {
            $save_data['pro_collections'] = implode(',',$data['collections']);
        }else
        {
            $save_data['pro_collections'] = '';
        }
        if(isset($data['product_tag']))
        {
            $save_data['pro_tag'] = $data['product_tag'];
        }else
        {
            $save_data['pro_tag'] = '';
        }
        if(isset($data['attr_category']))
        {
            $save_data['pro_attr_category'] = implode(',',$data['attr_category']);
        }else
        {
            $save_data['pro_attr_category'] = '';
        }
        
        
         if(isset($data['shades']))
        {
            $save_data['pro_shades'] = implode(',',$data['shades']);
        }else
        {
            $save_data['pro_shades'] = '';
        }

                        
        if($db->where('pro_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // Edit Color 


    public function featuresEdit()
    {
        $db = \Config\Database::connect()->table('cwf_products');
        $data['details'] =  $db->where('pro_active  ','A')->where('pro_id', $_GET['product_id'])->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();

        $db = dbconnect('cwf_cat_features');
        $data['features_list'] = $db->join('cwf_category', 'cwfcf_cat_id = cwf_category.cwf_cat_id')->join('cwf_features', 'cwfcf_features_id = cwf_features.cwff_id')->where('cwfcf_cat_id', $data['details']->cwf_cat_parent_id)->where('cwfcf_active', 'A')->where('cwff_active','1')->where('cwff_status','A')->orderby('cwff_order', 'ASC')->get()->getResult();

        if(empty($data['features_list']))
        {
            $db = dbconnect('cwf_features');
            $data['features_list'] = $db->where('cwff_active','1')->where('cwff_status','A')->orderby('cwff_order', 'ASC')->get()->getResult();
        }



        // echo "<pre>";
        // print_r($data);


        // exit();

        



        $db = dbconnect('cwf_pro_features');
        $data['list'] = $db->where('cwf_pf_product_id', $_GET['product_id'])->where('cwf_pf_active', 'A')->join('cwf_features', 'cwf_pf_features_id = cwf_features.cwff_id')->orderby('cwf_pf_order', 'ASC')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Cwf/product/features', $data);
        echo view('Admin/include/footer');
    }

    public function featuresEditView()
    {

        $db = \Config\Database::connect()->table('cwf_products');
        $data['details'] =  $db->where('pro_active  ','A')->where('pro_id', $_GET['product_id'])->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();

        $db = dbconnect('cwf_cat_features');
        $data['features_list'] = $db->join('cwf_category', 'cwfcf_cat_id = cwf_category.cwf_cat_id')->join('cwf_features', 'cwfcf_features_id = cwf_features.cwff_id')->where('cwfcf_cat_id', $data['details']->cwf_cat_parent_id)->where('cwfcf_active', 'A')->where('cwff_active','1')->where('cwff_status','A')->orderby('cwff_order', 'ASC')->get()->getResult();

        // $db = dbconnect('cwf_features');
        // $data['features_list'] = $db->where('cwff_active','1')->where('cwff_status','A')->orderby('cwff_order', 'ASC')->get()->getResult();

        $db = dbconnect('cwf_pro_features');
        $data['details'] = $db->where('cwf_pf_product_id', $_GET['product_id'])->where('cwf_pf_hash', $_GET['token'])->where('cwf_pf_active', 'A')->get()->getRow();

        echo view('Admin/include/header');
        echo view('Cwf/product/features_edit', $data);
        echo view('Admin/include/footer');
    }

    public function featuresAddconf($data, $custData)
    {
        $db = dbconnect('cwf_pro_features');
        $row_count = $db->where('cwf_pf_product_id', $data['product_id'])->where('cwf_pf_active', 'A')->get()->getResult();

        $checkData =  $db->where('cwf_pf_product_id', $data['product_id'])->where('cwf_pf_active', 'A')->where('cwf_pf_features_id', $data['parent'])->get()->getResult();

        if($checkData)
        {
            session()->setFlashdata("error", "Data already added");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }

        $save_data = array(
                            'cwf_pf_hash' => createHash(),
                            'cwf_pf_product_id' => $data['product_id'],
                            'cwf_pf_features_id' => $data['parent'],
                            'cwf_pf_content' => $data['content'],
                            'cwf_pf_i' => ltrim($data['info']),
                            'cwf_pf_order' => count($row_count) + 1,
                            'cwf_pf_status' => 'A',
                            'cwf_pf_active' => 'A',
                            'cwf_pf_created_at' => date("Y-m-d h:i:s"),
                            'cwf_pf_created_ip' => $this->request->getIPAddress(),
                            'cwf_pf_created_id' => dsession_id(),
                            'cwf_pf_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_pf_updated_id' => dsession_id(),
                            'cwf_pf_updated_at' => date("Y-m-d h:i:s"),

                        );

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Data Added.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }

    public function featuresEditConf($data, $custData)
    {
        $db = dbconnect('cwf_pro_features');
            

        $save_data = array(
                            'cwf_pf_content' => $data['content'],
                            'cwf_pf_status' => $data['status'],
                            'cwf_pf_i' => ltrim($data['info']),
                            'cwf_pf_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_pf_updated_id' => dsession_id(),
                            'cwf_pf_updated_at' => date("Y-m-d h:i:s"),

                        );

        if($db->where('cwf_pf_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Data Added.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }

    public function dimensionsEdit()
    {

        $db = \Config\Database::connect()->table('cwf_products');
        $data['details'] =  $db->where('pro_active  ','A')->where('pro_id', $_GET['product_id'])->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();

        $db = dbconnect('cwf_cat_dimensions');
        $data['dimensions_list'] = $db->join('cwf_category', 'cwfcd_cat_id = cwf_category.cwf_cat_id')->join('cwf_dimensions', 'cwfcd_dimensions_id = cwf_dimensions.cwf_dim_id')->where('cwfcd_cat_id', $data['details']->cwf_cat_parent_id)->where('cwfcd_active', 'A')->where('cwf_dim_active','1')->where('cwf_dim_status','A')->orderby('cwf_dim_order', 'ASC')->get()->getResult();

        if(empty($data['dimensions_list']))
        {
            $db = dbconnect('cwf_dimensions');
            $data['dimensions_list'] = $db->where('cwf_dim_active','1')->where('cwf_dim_status','A')->orderby('cwf_dim_order', 'ASC')->get()->getResult();
        }

        

        $db = dbconnect('cwf_pro_dimensions');
        $data['list'] = $db->where('cwf_pd_product_id', $_GET['product_id'])->where('cwf_pd_active', 'A')->join('cwf_dimensions', 'cwf_pd_dimensions_id = cwf_dimensions.cwf_dim_id')->orderby('cwf_pd_order', 'ASC')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Cwf/product/dimensions', $data);
        echo view('Admin/include/footer');
    }


    public function dimensionsEditView()
    {
        $db = \Config\Database::connect()->table('cwf_products');
        $data['details'] =  $db->where('pro_active  ','A')->where('pro_id', $_GET['product_id'])->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();

        $db = dbconnect('cwf_cat_dimensions');
        $data['dimensions_list'] = $db->join('cwf_category', 'cwfcd_cat_id = cwf_category.cwf_cat_id')->join('cwf_dimensions', 'cwfcd_dimensions_id = cwf_dimensions.cwf_dim_id')->where('cwfcd_cat_id', $data['details']->cwf_cat_parent_id)->where('cwfcd_active', 'A')->where('cwf_dim_active','1')->where('cwf_dim_status','A')->orderby('cwf_dim_order', 'ASC')->get()->getResult();

        if(empty($data['dimensions_list']))
        {
            $db = dbconnect('cwf_dimensions');
            $data['dimensions_list'] = $db->where('cwf_dim_active','1')->where('cwf_dim_status','A')->orderby('cwf_dim_order', 'ASC')->get()->getResult();
        }

        $db = dbconnect('cwf_pro_dimensions');
        $data['details'] = $db->where('cwf_pd_product_id', $_GET['product_id'])->where('cwf_pd_hash', $_GET['token'])->where('cwf_pd_active', 'A')->get()->getRow();

        

        echo view('Admin/include/header');
        echo view('Cwf/product/dimensions_edit', $data);
        echo view('Admin/include/footer');
    }

    public function dimensionsAddconf($data, $custData)
    {

        // echo "<pre>";
        // print_r($data);
        // exit();


        $db = dbconnect('cwf_pro_dimensions');
        $row_count = $db->where('cwf_pd_product_id', $data['product_id'])->where('cwf_pd_active', 'A')->get()->getResult();

        $checkData =  $db->where('cwf_pd_product_id', $data['product_id'])->where('cwf_pd_active', 'A')->where('cwf_pd_dimensions_id', $data['parent'])->get()->getResult();

        if($checkData)
        {
            session()->setFlashdata("error", "Data already added");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }

        $save_data = array(
                            'cwf_pd_hash' => createHash(),
                            'cwf_pd_product_id' => $data['product_id'],
                            'cwf_pd_dimensions_id' => $data['parent'],
                            'cwf_pd_content' => $data['content'],
                            'cwf_pd_i' => ltrim($data['info']),
                            'cwf_pd_order' => count($row_count) + 1,
                            'cwf_pd_status' => 'A',
                            'cwf_pd_active' => 'A',
                            'cwf_pd_created_at' => date("Y-m-d h:i:s"),
                            'cwf_pd_created_ip' => $this->request->getIPAddress(),
                            'cwf_pd_created_id' => dsession_id(),
                            'cwf_pd_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_pd_updated_id' => dsession_id(),
                            'cwf_pd_updated_at' => date("Y-m-d h:i:s"),

                        );

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Data Added.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }

    public function dimensionsEditConf($data, $custData)
    {
        $db = dbconnect('cwf_pro_dimensions');
            

        $save_data = array(
                            'cwf_pd_content' => $data['content'],
                            'cwf_pd_status' => $data['status'],
                            'cwf_pd_i' => ltrim($data['info']),
                            'cwf_pd_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_pd_updated_id' => dsession_id(),
                            'cwf_pd_updated_at' => date("Y-m-d h:i:s"),

                        );

        if($db->where('cwf_pd_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Data Added.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }


    public function technicalInfo()
    {


        $db = \Config\Database::connect()->table('cwf_products');
        $data['details'] =  $db->where('pro_active  ','A')->where('pro_id', $_GET['product_id'])->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();

        $db = dbconnect('cwf_cat_tech_info');
        $data['ti_list'] = $db->join('cwf_category', 'cwfcti_cat_id = cwf_category.cwf_cat_id')->join('cwf_tech_info', 'cwfcti_tech_info_id = cwf_tech_info.cwf_ti_id')->where('cwfcti_cat_id', $data['details']->cwf_cat_parent_id)->where('cwfcti_active', 'A')->where('cwf_ti_active','1')->where('cwf_ti_status','A')->orderby('cwf_ti_order', 'ASC')->get()->getResult();

        if(empty($data['ti_list']))
        {
            $db = dbconnect('cwf_tech_info');
            $data['ti_list'] = $db->where('cwf_ti_active','1')->where('cwf_ti_status','A')->orderby('cwf_ti_order', 'ASC')->get()->getResult();
        }


        

        $db = dbconnect('cwf_pro_techinfo');
        $data['list'] = $db->where('cwf_pti_product_id', $_GET['product_id'])->where('cwf_pti_active', 'A')->join('cwf_tech_info', 'cwf_pti_techinfo_id = cwf_tech_info.cwf_ti_id')->orderby('cwf_pti_order', 'ASC')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Cwf/product/technical-information', $data);
        echo view('Admin/include/footer');
    }

    public function technicalInfoEditView()
    {
        
        $db = \Config\Database::connect()->table('cwf_products');
        $data['details'] =  $db->where('pro_active  ','A')->where('pro_id', $_GET['product_id'])->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();

        $db = dbconnect('cwf_cat_tech_info');
        $data['ti_list'] = $db->join('cwf_category', 'cwfcti_cat_id = cwf_category.cwf_cat_id')->join('cwf_tech_info', 'cwfcti_tech_info_id = cwf_tech_info.cwf_ti_id')->where('cwfcti_cat_id', $data['details']->cwf_cat_parent_id)->where('cwfcti_active', 'A')->where('cwf_ti_active','1')->where('cwf_ti_status','A')->orderby('cwf_ti_order', 'ASC')->get()->getResult();

        if(empty($data['ti_list']))
        {
            $db = dbconnect('cwf_tech_info');
            $data['ti_list'] = $db->where('cwf_ti_active','1')->where('cwf_ti_status','A')->orderby('cwf_ti_order', 'ASC')->get()->getResult();
        }

        $db = dbconnect('cwf_pro_techinfo');
        $data['details'] = $db->where('cwf_pti_product_id', $_GET['product_id'])->where('cwf_pti_hash', $_GET['token'])->where('cwf_pti_active', 'A')->get()->getRow();

        

        echo view('Admin/include/header');
        echo view('Cwf/product/technical-information_edit', $data);
        echo view('Admin/include/footer');
    }

    public function technicalInfoAddconf($data, $custData)
    {

        // echo "<pre>";
        // print_r($data);
        // exit();


        $db = dbconnect('cwf_pro_techinfo');
        $row_count = $db->where('cwf_pti_product_id', $data['product_id'])->where('cwf_pti_active', 'A')->get()->getResult();

        $checkData =  $db->where('cwf_pti_product_id', $data['product_id'])->where('cwf_pti_active', 'A')->where('cwf_pti_techinfo_id', $data['parent'])->get()->getResult();

        if($checkData)
        {
            session()->setFlashdata("error", "Data already added");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }

        $save_data = array(
                            'cwf_pti_hash' => createHash(),
                            'cwf_pti_product_id' => $data['product_id'],
                            'cwf_pti_techinfo_id' => $data['parent'],
                            'cwf_pti_content' => $data['content'],
                            'cwf_pti_i' => ltrim($data['info']),
                            'cwf_pti_order' => count($row_count) + 1,
                            'cwf_pti_status' => 'A',
                            'cwf_pti_active' => 'A',
                            'cwf_pti_created_at' => date("Y-m-d h:i:s"),
                            'cwf_pti_created_ip' => $this->request->getIPAddress(),
                            'cwf_pti_created_id' => dsession_id(),
                            'cwf_pti_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_pti_updated_id' => dsession_id(),
                            'cwf_pti_updated_at' => date("Y-m-d h:i:s"),

                        );

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Data Added.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }

    
    public function technicalInfoEditConf($data, $custData)
    {
        $db = dbconnect('cwf_pro_techinfo');
            

        $save_data = array(
                            'cwf_pti_content' => $data['content'],
                            'cwf_pti_status' => $data['status'],
                            'cwf_pti_i' => ltrim($data['info']),
                            'cwf_pti_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_pti_updated_id' => dsession_id(),
                            'cwf_pti_updated_at' => date("Y-m-d h:i:s"),

                        );

        if($db->where('cwf_pti_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Data Added.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }


    public function imagesEdit()
    {


        $db = dbconnect('cwf_prod_images');
        $data['list'] = $db->where('cwfpi_product_id', $_GET['product_id'])->where('cwfpi_active', 'A')->orderby('cwfpi_order', 'ASC')->get()->getResult();

        $db = dbconnect('cwf_products');
        $data['details'] = $db->where('pro_id', $_GET['product_id'])->where('pro_active', 'A')->get()->getRow();
    
    
        $db = dbconnect('cwf_prod_color'); 
        $data['color_list'] = $db->where('cwfpc_active','A')->where('cwfpc_status','A')->where('cwfpc_product_id', $_GET['product_id'])->orderby('cwfpc_order', 'ASC')->join('cwf_color', 'cwfpc_color_id = cwf_color.cwfc_id')->get()->getResult();
    
        echo view('Admin/include/header');
        echo view('Cwf/product/images', $data);
        echo view('Admin/include/footer');
    }

    public function imagesEditView()
    {
        $db = dbconnect('cwf_prod_images');
        $data['details'] = $db->where('cwfpi_hash', $_GET['token'])->where('cwfpi_active', 'A')->get()->getRow();
        
        
        $db = dbconnect('cwf_prod_color'); 
        $data['color_list'] = $db->where('cwfpc_active','A')->where('cwfpc_status','A')->where('cwfpc_product_id', $_GET['product_id'])->orderby('cwfpc_order', 'ASC')->join('cwf_color', 'cwfpc_color_id = cwf_color.cwfc_id')->get()->getResult();
        
        echo view('Admin/include/header');
        echo view('Cwf/product/image-edit', $data);
        echo view('Admin/include/footer');
    }


    public function imagesEditconf($data, $custome_data)
    {
        $db = dbconnect('cwf_prod_images');

        if($_FILES['file']['name'])
        {  
            // Image
            $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[file,image/jpg,image/jpeg,image/gif,image/png]',
                    'max_size[file,1024]',
                ],
            ]);

            $path = './uploads/images/product-images/'.$data['product_id'];

            if(!$validated) {
                session()->setFlashdata("error", "Please Upload Valid File");
                return $this->response->redirect(current_url().'?action=edit&section='.$data['section'].'&product_id='.$data['product_id']);
            }

            $avatar = $this->request->getFile('file');
            $file_name =  $avatar->getName();
            $ext = $avatar->getClientExtension();
            $name = str_replace('.'.$ext,'-', $file_name);
            $name = str_replace(' ','-', $name);
            $final_name = $data['product_id'].'-'.$name.getDate()[0].'.'.$ext;
            $avatar->move($path, $final_name);

        }else
        {
            $final_name = '';
        }


        $save_data = array(
                            'cwfpi_name'=> $data['title'],
                            'cwfpi_status' => $data['status'],
                            'cwfpi_color' => $data['img_color'],
                            'cwfpi_updated_ip'  => $this->request->getIPAddress(),
                            'cwfpi_updated_id' => dsession_id(),
                            'cwfpi_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($final_name)
        {
            $save_data['cwfpi_image'] = $final_name;
        }

        if($db->where('cwfpi_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Product Color Added successfully");
            return $this->response->redirect(current_url().'?action=edit&section='.$data['section'].'&product_id='.$data['product_id']);
        }else{
            session()->setFlashdata("error", "Somting went wrong, please try again!");
            return $this->response->redirect(current_url().'?action=edit&section='.$data['section'].'&product_id='.$data['product_id']);
        }

    }

    public function imageAddconf($data, $custome_data)
    {
        // echo "<pre>";
        // print_r($data);
        // exit();
        $db = dbconnect('cwf_prod_images');

        $path = './uploads/images/product-images/'.$data['product_id'];
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }

        $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[image/jpg,image/jpeg,image/gif,image/png]',
                    'max_size[file,1024]',
                ],
            ]);


        $avatar = $this->request->getFile('file');
        $file_name =  $avatar->getName();
        $ext = $avatar->getClientExtension();

         $name = str_replace('.'.$ext,'-', $file_name);
         $name = str_replace(' ','-', $name);

        if(empty($data['title']))
         {
            $imageName = str_replace('.'.$ext,'', $file_name);
        }else
        {
           $imageName = $data['title'];
        }


         $final_name = $data['product_id'].'-'.$name.getDate()[0].'.'.$ext;

        $avatar->move($path, $final_name);

        $results_count = $db->where('cwfpi_product_id', $data['product_id'])->where('cwfpi_active', 'A')->get()->getResult();

        $save_data = array(
                            'cwfpi_hash'=> createHash(),
                            'cwfpi_name'=> $imageName,
                            'cwfpi_product_id' => $data['product_id'],
                            'cwfpi_image' => $final_name,
                            'cwfpi_color' => $data['img_color'],
                            'cwfpi_order' => count($results_count) + 1 ,
                            'cwfpi_status' => 'A',
                            'cwfpi_active' => 'A',
                            'cwfpi_created_at' => date("Y-m-d h:i:s"),
                            'cwfpi_created_ip' => $this->request->getIPAddress(),
                            'cwfpi_created_id' => dsession_id(),
                            'cwfpi_updated_ip'  => $this->request->getIPAddress(),
                            'cwfpi_updated_id' => dsession_id(),
                            'cwfpi_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            // session()->setFlashdata("success", "Image Uploaded.");
            // return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
            $db = dbconnect('cwf_prod_images');
            $total_proimgrows = $db->where('cwfpi_product_id', $_GET['product_id'])->where('cwfpi_active', 'A')->where('cwfpi_status', 'A')->get()->getResult();

            if(count($total_proimgrows) == 1)
            {
                $insertedData = $db->where('cwfpi_hash', $save_data['cwfpi_hash'])->get()->getRow();

                $db = \Config\Database::connect()->table('cwf_products');
                $updated_data = array(
                            'pro_main_image' => $insertedData->cwfpi_id,
                            'pro_hover_main_image' => $insertedData->cwfpi_id,
                            'pro_updated_ip'  => $this->request->getIPAddress(),
                            'pro_updated_id' => dsession_id(),
                            'pro_updated_at' => date("Y-m-d h:i:s"),
                        );

                if($db->where('pro_id', $_GET['product_id'])->set($updated_data)->update())
                {
                    session()->setFlashdata("success", "Image Uploaded.");
                    return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
                }else
                {
                    session()->setFlashdata("success", "Image Uploaded.");
                    return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
                }



            }else
            {
                session()->setFlashdata("success", "Image Uploaded.");
                return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
            }
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }

    }

    public function priceEdit()
    {
       $db = dbconnect('cwf_products'); 
        // $data['details'] = $db->where('pro_id', $_GET['product_id'])->where('pro_active', 'A')->get()->getRow(); 

        $data['details'] = $db->where('pro_id', $_GET['product_id'])->where('pro_active', 'A')->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow(); 
        


        // $db = dbconnect('cwf_pro_variant');

        $db = dbconnect('cwf_pro_variant');
        if($data['details']->cwf_cat_parent_id == '8' OR ($data['details']->cwf_cat_parent_id == '10') OR ($data['details']->cwf_cat_parent_id == '11'))
        {
            $data['list'] = $db->where('cwf_pv_product_id', $_GET['product_id'])->orderBy('cwf_pv_order', 'ASC')->where('cwf_pv_active', 'A')->get()->getResult();
        }else
        {
            $data['list'] = $db->where('cwf_pv_product_id', $_GET['product_id'])->orderBy('cwf_pv_order', 'ASC')->where('cwf_pv_active', 'A')->join('carpet_width', 'cwf_pv_width_id = carpet_width.cw_id')->get()->getResult();
        }

        
        // $data['list'] = $db->where('cwf_pv_product_id', $_GET['product_id'])->orderBy('cwf_pv_order', 'ASC')->where('cwf_pv_active', 'A')->join('carpet_width', 'cwf_pv_width_id = carpet_width.cw_id')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Cwf/product/price', $data);
        echo view('Admin/include/footer');
       
    }

    public function seoEdit()
    {
        $db = dbconnect('cwf_products'); 
        $data['details'] = $db->where('pro_id', $_GET['product_id'])->where('pro_active', 'A')->get()->getRow();
        echo view('Admin/include/header');
        echo view('Cwf/product/seo', $data);
        echo view('Admin/include/footer');
    }

    public function seoEditConf($data, $custome_data)
    {   
        $db = dbconnect('cwf_products'); 

        $save_data = array(
                            'pro_seo_title' => $data['title'],
                            'pro_seo_keywords' => $data['keywords'],
                            'pro_seo_descriptions' => $data['description'],
                            'pro_seo_content' => $data['content'],
                            'pro_updated_ip'  => $this->request->getIPAddress(),
                            'pro_updated_id' => dsession_id(),
                            'pro_updated_at' => date("Y-m-d h:i:s"),
                        );
        if($db->where('pro_id', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Product Data Updated.");
            return $this->response->redirect(current_url().'?action=edit&section='.$data['section'].'&product_id='.$data['product_id']);
        }else{
            session()->setFlashdata("error", "Somting went wrong, please try again!");
            return $this->response->redirect(current_url().'?action=edit&section='.$data['section'].'&product_id='.$data['product_id']);
        }
    }

    public function statusEdit()
    {
        $db = dbconnect('cwf_products'); 
        $data['details'] = $db->where('pro_id', $_GET['product_id'])->where('pro_active', 'A')->get()->getRow();  
        echo view('Admin/include/header');
        echo view('Cwf/product/status', $data);
        echo view('Admin/include/footer');
    }

    public function otherEdit()
    {
        $db = dbconnect('cwf_products'); 
        $data['details'] = $db->where('pro_id', $_GET['product_id'])->where('pro_active', 'A')->get()->getRow(); 

        $db = dbconnect('cwf_brand');
        $data['list'] = $db->where('cwfb_active','A')->where('cwfb_status','A')->orderby('cwfb_order', 'ASC')->get()->getResult();


        echo view('Admin/include/header');
        echo view('Cwf/product/other', $data);
        echo view('Admin/include/footer');
    }

    public function statusEditConf($data, $custome_data)
    {   
        $db = dbconnect('cwf_products'); 

        $save_data = array(
                            'pro_status' => $data['status'],
                            'pro_out_of_stock' => $data['out_of_stock'],
                            'pro_updated_ip'  => $this->request->getIPAddress(),
                            'pro_updated_id' => dsession_id(),
                            'pro_updated_at' => date("Y-m-d h:i:s"),
                        );
        if($db->where('pro_id', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Product Data Updated.");
            return $this->response->redirect(current_url().'?action=edit&section='.$data['section'].'&product_id='.$data['product_id']);
        }else{
            session()->setFlashdata("error", "Somting went wrong, please try again!");
            return $this->response->redirect(current_url().'?action=edit&section='.$data['section'].'&product_id='.$data['product_id']);
        }
    }

    public function otherEditConf($data, $custome_data)
    {   
        $db = dbconnect('cwf_products'); 

        $save_data = array(
                            'pro_brand' => $data['brand'],
                            'pro_updated_ip'  => $this->request->getIPAddress(),
                            'pro_updated_id' => dsession_id(),
                            'pro_updated_at' => date("Y-m-d h:i:s"),
                        );
        if($db->where('pro_id', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Product Data Updated.");
            return $this->response->redirect(current_url().'?action=edit&section='.$data['section'].'&product_id='.$data['product_id']);
        }else{
            session()->setFlashdata("error", "Somting went wrong, please try again!");
            return $this->response->redirect(current_url().'?action=edit&section='.$data['section'].'&product_id='.$data['product_id']);
        }
    }

    public function colorEdit()
    {
        $db = dbconnect('cwf_color'); 
        $data['color_list'] = $db->where('cwfc_active','A')->where('cwfc_status','A')->orderby('cwfc_order', 'ASC')->get()->getResult();

        $db = dbconnect('cwf_prod_color'); 
        $data['list'] = $db->where('cwfpc_active','A')->where('cwfpc_product_id', $_GET['product_id'])->orderby('cwfpc_order', 'ASC')->join('cwf_color', 'cwfpc_color_id = cwf_color.cwfc_id')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Cwf/product/color', $data);
        echo view('Admin/include/footer');
    }

    public function colorEditconf($data, $custome_data)
    {
        $db = dbconnect('cwf_prod_color'); 
        $updateData = array(
                                'cwfpc_status' => $data['status'],
                                'cwfpc_updated_ip'  => $this->request->getIPAddress(),
                                'cwfpc_updated_id' => dsession_id(),
                                'cwfpc_updated_at' => date("Y-m-d h:i:s"),
                            );

        if($db->where('cwfpc_hash', $data['token'])->set($updateData)->update())
        {
            session()->setFlashdata("success", "Product Color Added successfully");
            return $this->response->redirect(current_url().'?action=edit&section=color&product_id='.$data['product_id']);
        }else{
            session()->setFlashdata("error", "Somting went wrong, please try again!");
            return $this->response->redirect(current_url().'?action=edit&section=color&product_id='.$data['product_id']);
        }

    }

    public function colorEditView()
    {
        // echo "Color Edit View Page";
        // echo "<pre>";
        // print_r($_GET);
        // echo "</pre>";
        $db = dbconnect('cwf_prod_color'); 
        $data['details'] = $db->where('cwfpc_active','A')->where('cwfpc_hash', $_GET['token'])->where('cwfpc_product_id', $_GET['product_id'])->orderby('cwfpc_order', 'ASC')->join('cwf_color', 'cwfpc_color_id = cwf_color.cwfc_id')->get()->getRow();

        // echo "<pre>";
        // print_r($data);
        // exit();

        echo view('Admin/include/header');
        echo view('Cwf/product/color-edit', $data);
        echo view('Admin/include/footer');
    }

    public function colorAddconf($data, $custome_data)
    {
        $db = dbconnect('cwf_prod_color'); 
        // echo "<pre>";
        // print_r($data);
        // exit();


        foreach($data['color'] as $c)
        {
            $related_results = $db->where('cwfpc_color_id',$c)->where('cwfpc_product_id', $data['product_id'])->where('cwfpc_active','A')->get()->getResult();

            if(!$related_results)
            {
                $row_count = $db->where('cwfpc_product_id', $data['product_id'])->get()->getResult();
                // echo $c.'<br>';

                $save_data = array(
                            'cwfpc_hash' => createHash(),
                            'cwfpc_product_id' => $data['product_id'],
                            'cwfpc_color_id' => $c,
                            'cwfpc_order' => count($row_count) + 1,
                            'cwfpc_status' => 'A',
                            'cwfpc_active' => 'A',
                            'cwfpc_created_at' => date("Y-m-d h:i:s"),
                            'cwfpc_created_ip' => $this->request->getIPAddress(),
                            'cwfpc_created_id' => dsession_id(),
                            'cwfpc_updated_ip'  => $this->request->getIPAddress(),
                            'cwfpc_updated_id' => dsession_id(),
                            'cwfpc_updated_at' => date("Y-m-d h:i:s"),

                        );
                $db->insert($save_data);

            }
        }

        session()->setFlashdata("success", "Product Color Added successfully");
        return $this->response->redirect(current_url().'?action=edit&section=color&product_id='.$data['product_id']);
        
    }


    
   

    public function accessoriesEdit()
    {
        $db = dbconnect('cwf_category');
        $data['cat_list'] = $db->where('cwf_cat_active','A')->where('cwf_cat_status','A')->orderby('cwf_cat_order', 'ASC')->where('cwf_cat_parent_id', '170')->get()->getResult();

        $db = dbconnect('cwf_prod_accessories');
        $data['list'] = $db->where('cwfpa_product_id', $_GET['product_id'])->where('cwfpa_active', 'A')->orderby('cwfpa_order', 'ASC')->join('cwf_products', 'cwfpa_cat_pro_id = cwf_products.pro_id')->get()->getResult();
        
        $db = dbconnect('cwf_pro_sku');
        $data['sku_list'] = $db->where('cwf_psku_product_id', $_GET['product_id'])->where('cwf_psku_active', 'A')->where('cwf_psku_status', 'A')->join('cwf_prod_color', 'cwf_psku_color_id = cwf_prod_color.cwfpc_id')->join('cwf_color', 'cwfpc_color_id = cwf_color.cwfc_id')->orderby('cwf_psku_order', 'ASC')->get()->getResult();
        
        echo view('Admin/include/header');
        echo view('Cwf/product/accessories', $data);
        echo view('Admin/include/footer');
    }

    public function accessoriesEditView()
    {
        $db = dbconnect('cwf_prod_accessories');
        $data['details'] = $db->where('cwfpa_product_id', $_GET['product_id'])->where('cwfpa_active', 'A')->where('cwfpa_hash', $_GET['token'])->join('cwf_products', 'cwfpa_cat_pro_id = cwf_products.pro_id')->get()->getRow();
        
        $db = dbconnect('cwf_pro_sku');
        $data['sku_list'] = $db->where('cwf_psku_product_id', $_GET['product_id'])->where('cwf_psku_active', 'A')->where('cwf_psku_status', 'A')->join('cwf_prod_color', 'cwf_psku_color_id = cwf_prod_color.cwfpc_id')->join('cwf_color', 'cwfpc_color_id = cwf_color.cwfc_id')->orderby('cwf_psku_order', 'ASC')->get()->getResult();
        
        echo view('Admin/include/header');
        echo view('Cwf/product/accessories_edit', $data);
        echo view('Admin/include/footer');

    }

    public function accessoriesAddconf($data, $custome_data)
    {
        $db = dbconnect('cwf_prod_accessories');
        $row_count = $db->where('cwfpa_product_id', $data['product_id'])->where('cwfpa_active', 'A')->get()->getResult();

        $checkData =  $db->where('cwfpa_product_id', $data['product_id'])->where('cwfpa_active', 'A')->where('cwfpa_cat_id', $data['sub_category'])->where('cwfpa_cat_pro_id',$data['product'])->get()->getResult();

        if($checkData)
        {
            session()->setFlashdata("error", "Product already added");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }

        // echo "<pre>";
        // print_r($data);
        // exit();

        $save_data = array(
                            'cwfpa_hash' => createHash(),
                            'cwfpa_product_id' => $data['product_id'],
                            'cwfpa_cat_id' => $data['sub_category'],
                            'cwfpa_cat_pro_id' => $data['product'],
                            'cwfpa_order' => count($row_count) + 1,
                            'cwfpa_status' => 'A',
                            'cwfpa_active' => 'A',
                            'cwfpa_created_at' => date("Y-m-d h:i:s"),
                            'cwfpa_created_ip' => $this->request->getIPAddress(),
                            'cwfpa_created_id' => dsession_id(),
                            'cwfpa_updated_ip'  => $this->request->getIPAddress(),
                            'cwfpa_updated_id' => dsession_id(),
                            'cwfpa_updated_at' => date("Y-m-d h:i:s"),

                        );
        
        if(isset($data['sku_list']))
        {
            $save_data['cwfpa_sku_ids'] = implode(',', $data['sku_list']);
        }
        
        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Accessories Uploaded.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }


    public function accessoriesEditconf($data, $custome_data)
    {



        $db = dbconnect('cwf_prod_accessories');
        $save_data = array(
                            'cwfpa_status' => $data['status'],
                            'cwfpa_updated_ip'  => $this->request->getIPAddress(),
                            'cwfpa_updated_id' => dsession_id(),
                            'cwfpa_updated_at' => date("Y-m-d h:i:s"),

                        );
        
        if(isset($data['sku_list']))
        {
            $save_data['cwfpa_sku_ids'] = implode(',', $data['sku_list']);
        }else
        {
            $save_data['cwfpa_sku_ids'] = '';
        }
        
        if($db->where('cwfpa_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Accessories Updated.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }

    public function filterEdit()
    {
        $db = \Config\Database::connect()->table('cwf_products');
        $data['details'] =  $db->where('pro_active  ','A')->where('pro_id', $_GET['product_id'])->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();
        $db = \Config\Database::connect()->table('cwf_category');
        $data['catData'] =  $db->where('cwf_cat_active','A')->where('cwf_cat_id', $data['details']->cwf_cat_parent_id)->get()->getRow();

        $db = dbconnect('cwf_filters');
        $data['filter_list'] = $db->whereIn('cwf_fltr_id', explode(',', $data['catData']->cwf_cat_filters))->where('cwf_fltr_active','1')->where('cwf_fltr_status','A')->orderby('cwf_fltr_order', 'ASC')->get()->getResult();

        $db = dbconnect('cwf_pro_filters');
        $data['list'] = $db->where('cwf_pfltr_product_id', $_GET['product_id'])->where('cwf_pfltr_active', 'A')->join('cwf_filters_value', 'cwf_pfltr_filter_value = cwf_filters_value.cwf_fltrvlu_id')->join('cwf_filters', 'cwf_pfltr_filter_id = cwf_filters.cwf_fltr_id')->orderby('cwf_pfltr_order', 'ASC')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Cwf/product/filters', $data);
        echo view('Admin/include/footer');
    }

    public function skuEdit()
    {
        $db = \Config\Database::connect()->table('cwf_products');
        $data['details'] =  $db->where('pro_active  ','A')->where('pro_id', $_GET['product_id'])->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();

        $db = \Config\Database::connect()->table('cwf_category');
        $data['catData'] =  $db->where('cwf_cat_active','A')->where('cwf_cat_id', $data['details']->cwf_cat_parent_id)->get()->getRow();

        $db = dbconnect('cwf_prod_color'); 
        $data['color_list'] = $db->where('cwfpc_active','A')->where('cwfpc_status','A')->where('cwfpc_product_id', $_GET['product_id'])->orderby('cwfpc_order', 'ASC')->join('cwf_color', 'cwfpc_color_id = cwf_color.cwfc_id')->get()->getResult();

        $db = dbconnect('cwf_pro_sku');
        $data['skulist'] = $db->where('cwf_psku_product_id', $_GET['product_id'])->where('cwf_psku_active', 'A')->join('cwf_prod_color', 'cwf_psku_color_id = cwf_prod_color.cwfpc_id')->join('cwf_color', 'cwfpc_color_id = cwf_color.cwfc_id')->orderby('cwf_psku_order', 'ASC')->get()->getResult();




        $db = dbconnect('cwf_pro_variant');
        if($data['details']->cwf_cat_parent_id == '8' OR ($data['details']->cwf_cat_parent_id == '10') OR ($data['details']->cwf_cat_parent_id == '11'))
        {
            $data['list'] = $db->where('cwf_pv_product_id', $_GET['product_id'])->orderBy('cwf_pv_order', 'ASC')->where('cwf_pv_active', 'A')->get()->getResult();
        }else
        {
            $data['list'] = $db->where('cwf_pv_product_id', $_GET['product_id'])->orderBy('cwf_pv_order', 'ASC')->where('cwf_pv_active', 'A')->join('carpet_width', 'cwf_pv_width_id = carpet_width.cw_id')->get()->getResult();
        }







        echo view('Admin/include/header');
        echo view('Cwf/product/sku', $data);
        echo view('Admin/include/footer');
    }

    public function filterAddconf($data, $custData)
    {

        // echo "<pre>";
        // print_r($data);
        // exit();


        $db = dbconnect('cwf_pro_filters');
        $row_count = $db->where('cwf_pfltr_product_id', $data['product_id'])->where('cwf_pfltr_active', 'A')->get()->getResult();

        $checkData =  $db->where('cwf_pfltr_product_id', $data['product_id'])->where('cwf_pfltr_active', 'A')->where('cwf_pfltr_filter_value', $data['filter_option'])->get()->getResult();

        if($checkData)
        {
            session()->setFlashdata("error", "Data already added");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }

        $save_data = array(
                            'cwf_pfltr_hash' => createHash(),
                            'cwf_pfltr_product_id' => $data['product_id'],
                            'cwf_pfltr_filter_id' => $data['filter'],
                            'cwf_pfltr_filter_value' => $data['filter_option'],
                            'cwf_pfltr_order' => count($row_count) + 1,
                            'cwf_pfltr_status' => 'A',
                            'cwf_pfltr_active' => 'A',
                            'cwf_pfltr_created_at' => date("Y-m-d h:i:s"),
                            'cwf_pfltr_created_ip' => $this->request->getIPAddress(),
                            'cwf_pfltr_created_id' => dsession_id(),
                            'cwf_pfltr_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_pfltr_updated_id' => dsession_id(),
                            'cwf_pfltr_updated_at' => date("Y-m-d h:i:s"),

                        );

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Data Added.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }

    public function skuAddconf($data, $custData)
    {

        $db = dbconnect('cwf_pro_sku');
        $row_count = $db->where('cwf_psku_product_id', $data['product_id'])->where('cwf_psku_active', 'A')->get()->getResult();

        $checkData =  $db->where('cwf_psku_active', 'A')->where('cwf_psku_code', $data['sku_code'])->get()->getResult();
        $checkData2 =  $db->where('cwf_psku_product_id', $data['product_id'])->where('cwf_psku_active', 'A')->where('cwf_psku_color_id', $data['color'])->get()->getResult();
        $checkData3 =  $db->where('cwf_psku_product_id', $data['product_id'])->where('cwf_psku_active', 'A')->where('cwf_psku_supplier_code', $data['supplier_sku_code'])->get()->getResult();

        if($checkData OR $checkData2 OR $checkData3)
        {
            session()->setFlashdata("error", "Data already added");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }

        $save_data = array(
                            'cwf_psku_hash' => createHash(),
                            'cwf_psku_product_id' => $data['product_id'],
                            'cwf_psku_code' => $data['sku_code'],
                            'cwf_psku_color_id' => $data['color'],
                            'cwf_psku_supplier_code' => $data['supplier_sku_code'],
                            'cwf_psku_order' => count($row_count) + 1,
                            'cwf_psku_status' => 'A',
                            'cwf_psku_active' => 'A',
                            'cwf_psku_created_at' => date("Y-m-d h:i:s"),
                            'cwf_psku_created_ip' => $this->request->getIPAddress(),
                            'cwf_psku_created_id' => dsession_id(),
                            'cwf_psku_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_psku_updated_id' => dsession_id(),
                            'cwf_psku_updated_at' => date("Y-m-d h:i:s"),

                        );

        if(isset($data['variant']))
        {
            $save_data['cwf_psku_variant'] = implode(',', $data['variant']);
        }



        if($db->insert($save_data))
        {
             // session()->setFlashdata("success", "Data Added.");
            // return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));

            $db = dbconnect('cwf_pro_sku');
            $total_proimgrows = $db->where('cwf_psku_product_id', $data['product_id'])->where('cwf_psku_active', 'A')->where('cwf_psku_status', 'A')->get()->getResult();

            if(count($total_proimgrows) == 1)
            {
                $insertedData = $db->where('cwf_psku_hash', $save_data['cwf_psku_hash'])->get()->getRow();

                $db = \Config\Database::connect()->table('cwf_products');
                $updated_data = array(
                            'pro_main_sku' => $insertedData->cwf_psku_id,
                            'pro_updated_ip'  => $this->request->getIPAddress(),
                            'pro_updated_id' => dsession_id(),
                            'pro_updated_at' => date("Y-m-d h:i:s"),
                        );

                if($db->where('pro_id', $_GET['product_id'])->set($updated_data)->update())
                {
                    session()->setFlashdata("success", "Data Added.");
                    return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
                }else
                {
                    session()->setFlashdata("success", "Data Added.");
                    return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
                }



            }else
            {
                session()->setFlashdata("success", "Data Added.");
                return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
            }
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }

    public function filtersEditView()
    {
        
        $db = dbconnect('cwf_pro_filters');
        $data['details'] = $db->where('cwf_pfltr_product_id', $_GET['product_id'])->where('cwf_pfltr_active', 'A')->join('cwf_filters_value', 'cwf_pfltr_filter_value = cwf_filters_value.cwf_fltrvlu_id')->join('cwf_filters', 'cwf_pfltr_filter_id = cwf_filters.cwf_fltr_id')->orderby('cwf_pfltr_order', 'ASC')->get()->getRow();

        

        echo view('Admin/include/header');
        echo view('Cwf/product/filters_edit', $data);
        echo view('Admin/include/footer');
    }
    public function skuEditView()
    {
        $db = \Config\Database::connect()->table('cwf_products');
        $data['detail'] =  $db->where('pro_active  ','A')->where('pro_id', $_GET['product_id'])->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();

        $db = dbconnect('cwf_pro_sku');
        $data['details'] = $db->where('cwf_psku_hash', $_GET['token'])->where('cwf_psku_product_id', $_GET['product_id'])->where('cwf_psku_active', 'A')->join('cwf_prod_color', 'cwf_psku_color_id = cwf_prod_color.cwfpc_id')->join('cwf_color', 'cwfpc_color_id = cwf_color.cwfc_id')->orderby('cwf_psku_order', 'ASC')->get()->getRow();




        $db = dbconnect('cwf_pro_variant');
        if($data['detail']->cwf_cat_parent_id == '8' OR ($data['detail']->cwf_cat_parent_id == '10') OR ($data['detail']->cwf_cat_parent_id == '11'))
        {
            $data['list'] = $db->where('cwf_pv_product_id', $_GET['product_id'])->orderBy('cwf_pv_order', 'ASC')->where('cwf_pv_active', 'A')->get()->getResult();
        }else
        {
            $data['list'] = $db->where('cwf_pv_product_id', $_GET['product_id'])->orderBy('cwf_pv_order', 'ASC')->where('cwf_pv_active', 'A')->join('carpet_width', 'cwf_pv_width_id = carpet_width.cw_id')->get()->getResult();
        }

        echo view('Admin/include/header');
        echo view('Cwf/product/sku_edit', $data);
        echo view('Admin/include/footer');
    }

    public function filterEditconf($data, $custData)
    {
        $db = dbconnect('cwf_pro_filters');
            

        $save_data = array(
                            'cwf_pfltr_status' => $data['status'],
                            'cwf_pfltr_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_pfltr_updated_id' => dsession_id(),
                            'cwf_pfltr_updated_at' => date("Y-m-d h:i:s"),

                        );

        if($db->where('cwf_pfltr_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Data Added.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }

    public function skuEditconf($data, $custData)
    {
        $db = dbconnect('cwf_pro_sku');
            

        $save_data = array(
                            'cwf_psku_code' => $data['sku_code'],
                            'cwf_psku_supplier_code' => $data['supplier_sku_code'],
                            'cwf_psku_status' => $data['status'],
                            'cwf_psku_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_psku_updated_id' => dsession_id(),
                            'cwf_psku_updated_at' => date("Y-m-d h:i:s"),

                        );

        if(isset($data['variant']))
        {
            $save_data['cwf_psku_variant'] = implode(',', $data['variant']);
        }

        if($db->where('cwf_psku_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Data Added.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
    }




    public function variantEditView()
    {
        $db = dbconnect('cwf_pro_variant');
        $data['details'] = $db->where('cwf_pv_hash', $_GET['token'])->where('cwf_pv_active', 'A')->get()->getRow();
        
        $db = dbconnect('cwf_products');
        $data['detail'] = $db->where('pro_id', $_GET['product_id'])->where('pro_active', 'A')->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow(); 
        
        echo view('Admin/include/header');
        echo view('Cwf/product/variant-edit', $data);
        echo view('Admin/include/footer');
    }
    
    public function variantEditConf($data, $custome_data)
    {
        
        $db = dbconnect('cwf_pro_variant'); 

        $save_data = array(
                            'cwf_pv_status' => $data['status'],
                            'cwf_pv_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_pv_updated_id' => dsession_id(),
                            'cwf_pv_updated_at' => date("Y-m-d h:i:s"),
                        );
                        
                        
        if(isset($data['width']))
        {
            $save_data['cwf_pv_width_id'] = $data['width'];
        }
        if(isset($data['box_area']))
        {
            $save_data['cwf_pv_box_area'] = $data['box_area'];
        }
        if(isset($data['no_of_tiles']))
        {
            $save_data['cwf_pv_box_items_count'] = $data['no_of_tiles'];
        }            
                        
        if($db->where('cwf_pv_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Variant Data Updated.");
            return $this->response->redirect(current_url().'?action=edit&section='.$data['section'].'&product_id='.$data['product_id']);
        }else{
            session()->setFlashdata("error", "Somting went wrong, please try again!");
            return $this->response->redirect(current_url().'?action=edit&section='.$data['section'].'&product_id='.$data['product_id']);
        }


    }
 
    
    
    public function variantEdit()
    {
        $db = dbconnect('cwf_products'); 
        $data['details'] = $db->where('pro_id', $_GET['product_id'])->where('pro_active', 'A')->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow(); 

        // echo "<pre>";
        // print_r($data);
        // exit();

        $db = dbconnect('carpet_width');
        $data['width_list'] = $db->where('cw_parent_id', $data['details']->cwf_cat_parent_id)->get()->getResult();

        $db = dbconnect('cwf_pro_variant');
        if($data['details']->cwf_cat_parent_id == '8' OR ($data['details']->cwf_cat_parent_id == '10') OR ($data['details']->cwf_cat_parent_id == '11'))
        {
            $data['list'] = $db->where('cwf_pv_product_id', $_GET['product_id'])->orderBy('cwf_pv_order', 'ASC')->where('cwf_pv_active', 'A')->get()->getResult();
        }else
        {
            $data['list'] = $db->where('cwf_pv_product_id', $_GET['product_id'])->orderBy('cwf_pv_order', 'ASC')->where('cwf_pv_active', 'A')->join('carpet_width', 'cwf_pv_width_id = carpet_width.cw_id')->get()->getResult();
        }
        
        
        
        // echo "<pre>";
        // print_r
        
        
        
        echo view('Admin/include/header');
        echo view('Cwf/product/variant', $data);
        echo view('Admin/include/footer');
    }
    
    public function variantAddConf($data, $custData)
    {
        $db = dbconnect('cwf_pro_variant');
        $row_count = $db->where('cwf_pv_product_id', $data['product_id'])->where('cwf_pv_active', 'A')->get()->getResult();

        if(isset($data['width']))
        {
            $checkData =  $db->where('cwf_pv_product_id', $data['product_id'])->where('cwf_pv_active', 'A')->where('cwf_pv_width_id', $data['width'])->get()->getResult();
        }

        if(isset($data['box_area']))
        {
            $checkData =  $db->where('cwf_pv_product_id', $data['product_id'])->where('cwf_pv_active', 'A')->where('cwf_pv_box_area', $data['box_area'])->where('cwf_pv_box_items_count', $data['no_of_tiles'])->get()->getResult();
        }

        if($checkData)
        {
            session()->setFlashdata("error", "Data already added");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }
        $save_data = array(
                            'cwf_pv_hash' => createHash(),
                            'cwf_pv_product_id' => $data['product_id'],
                            'cwf_pv_order' => count($row_count) + 1,
                            'cwf_pv_status' => 'A',
                            'cwf_pv_active' => 'A',
                            'cwf_pv_created_at' => date("Y-m-d h:i:s"),
                            'cwf_pv_created_ip' => $this->request->getIPAddress(),
                            'cwf_pv_created_id' => dsession_id(),
                            'cwf_pv_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_pv_updated_id' => dsession_id(),
                            'cwf_pv_updated_at' => date("Y-m-d h:i:s"),

                        );

        if(isset($data['width']))
        {
            $save_data['cwf_pv_width_id'] = $data['width'];
        }
        if(isset($data['box_area']))
        {
            $save_data['cwf_pv_box_area'] = $data['box_area'];
        }
        if(isset($data['no_of_tiles']))
        {
            $save_data['cwf_pv_box_items_count'] = $data['no_of_tiles'];
        }
        // cwf_pv_box_area
        // cwf_pv_box_items_count


        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Data Added.");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=edit&section='.$data['section'].'&product_id='.$data['product_id']));
        }

    }
    
    
    // Upload Banner Images

     public function uploadBannerImages()
    {
        $data = $this->request->getVar();

        $db = dbconnect('cwf_pro_banner_images');
        $path = './uploads/images/product-banner-images/'.$data['id'];

        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }

        $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[image/jpg,image/jpeg,image/gif,image/png,image/webp]',
                    'max_size[file,1024]',
                ],
            ]);


        $avatar = $this->request->getFile('file');
        $file_name =  $avatar->getName();
        $ext = $avatar->getClientExtension();


         $name = str_replace('.'.$ext,'-', $file_name);
         $name = str_replace(' ','-', $name);

         if(empty($data['title']))
         {
            $imageName = str_replace('.'.$ext,'', $file_name);
         }else
        {
            $imageName = $data['title'];
        }


         $final_name = $data['id'].'-'.$name.getDate()[0].'.'.$ext;

        $avatar->move($path, $final_name);

        $results_count = $db->where('cwfpbi_pro_id', $data['id'])->where('cwfpbi_active', 'A')->get()->getResult();

        $save_data = array(
                            'cwfpbi_hash'=> createHash(),
                            'cwfpbi_name'=> $imageName,
                            'cwfpbi_pro_id' => $data['id'],
                            'cwfpbi_image' => $final_name,
                            'cwfpbi_order' => count($results_count) + 1 ,
                            'cwfpbi_status' => 'A',
                            'cwfpbi_active' => 'A',
                            'cwfpbi_created_at' => date("Y-m-d h:i:s"),
                            'cwfpbi_created_ip' => $this->request->getIPAddress(),
                            'cwfpbi_created_id' => dsession_id(),
                            'cwfpbi_updated_ip'  => $this->request->getIPAddress(),
                            'cwfpbi_updated_id' => dsession_id(),
                            'cwfpbi_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Image Uploaded.");
            return $this->response->redirect(site_url('admin/product?action=create&page=banner-images&id='.$data['id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/product?action=create&page=banner-images&id='.$data['id']));
        }
    }


    public function editBannerImage()
    {
        $datainput = $this->request->getVar();
        $db = dbconnect('cwf_pro_banner_images');

        $datas['details'] = $db->where('cwfpbi_active', 'A')->where('cwfpbi_hash', $datainput['token'])->get()->getRow();


        

        echo view('Admin/include/header');
        echo view('Cwf/product/pro-banner-images-edit', $datas);
        echo view('Admin/include/footer');
    }


    public function editBannerImageConf()
    {
        $data = $this->request->getVar();
        $db = dbconnect('cwf_pro_banner_images');

        if($_FILES['file']['name'])
        {  
            // Image
            $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[file,image/jpg,image/jpeg,image/gif,image/png,image/webp]',
                    'max_size[file,1024]',
                ],
            ]);

            $path = './uploads/images/product-banner-images/'.$data['id'];

            if(!$validated) {
                session()->setFlashdata("error", "Please Upload Valid File");
                return $this->response->redirect(current_url().'?token='.$data['token'].'&id='.$data['id']);
            }

            $avatar = $this->request->getFile('file');
            $file_name =  $avatar->getName();
            $ext = $avatar->getClientExtension();
            $name = str_replace('.'.$ext,'-', $file_name);
            $name = str_replace(' ','-', $name);
            $final_name = $data['id'].'-'.$name.getDate()[0].'.'.$ext;
            $avatar->move($path, $final_name);

        }else
        {
            $final_name = '';
        }


        $save_data = array(
                            'cwfpbi_name'=> $data['title'],
                            'cwfpbi_status' => $data['status'],
                            'cwfpbi_updated_ip'  => $this->request->getIPAddress(),
                            'cwfpbi_updated_id' => dsession_id(),
                            'cwfpbi_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($final_name)
        {
            $save_data['cwfpbi_image'] = $final_name;
        }

        if($db->where('cwfpbi_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Image Updated");
             return $this->response->redirect(current_url().'?token='.$data['token'].'&id='.$data['id']);
        }else{
            session()->setFlashdata("error", "Somting went wrong, please try again!");
             return $this->response->redirect(current_url().'?token='.$data['token'].'&id='.$data['id']);
        }
    }


    public function deleteProductVariant()
    {
        $token = $_GET['token'];

        $db = dbconnect('cwf_pro_variant');

        $update_data = array(
                            'cwf_pv_active'=> 'D',
                            'cwf_pv_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_pv_updated_id' => dsession_id(),
                            'cwf_pv_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->where('cwf_pv_hash', $token)->set($update_data)->update())
        {
            session()->setFlashdata("success", "Variant Deleted");
             return $this->response->redirect(site_url('admin/product?action=edit&section=variant&product_id='.$_GET['id']));
         }else
         {
            session()->setFlashdata("error", "Somting went wrong, please try again!");
             return $this->response->redirect(site_url('admin/product?action=edit&section=variant&product_id='.$_GET['id']));
         }


    }




}

