<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class FiltersOptionsController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = dbconnect('cwf_filters_value');
        $data['list'] = $db->where('cwf_fltrvlu_active','A')
                       ->where('cwf_fltrvlu_fltr_id',$_GET['filter'] ?? '-1')
                       ->orderby('cwf_fltrvlu_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/filters-options/list', $data);
        echo view('Admin/include/footer');
    }



    public function ajax_list()
    {
        $db = dbconnect('cwf_filters_value');
        $list = $db->where('cwf_fltrvlu_active','A')->where('cwf_fltrvlu_fltr_id',$_GET['filter'])->orderby('cwf_fltrvlu_order', 'ASC')->get()->getResult();

        echo '<option value="">Select</option>';
        foreach($list as $ls)
        {
            echo "<option value=".$ls->cwf_fltrvlu_id.">".$ls->cwf_fltrvlu_name."</option>";
        }

    }



    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Cwf/filters-options/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = dbconnect('cwf_filters_value');

           
            $results = $db->where('cwf_fltrvlu_name', $data['title'])->where('cwf_fltrvlu_active','A')->get()->getResult();
            $results_count = $db->where('cwf_fltrvlu_fltr_id', $_GET['filter'])->get()->getResult();

            if($results)
            {
                session()->setFlashdata("error", "Data Not Unique");
                return $this->response->redirect(current_url());
            }

            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
            }

        $save_data = array(
                            'cwf_fltrvlu_hash'=> createHash(),
                            'cwf_fltrvlu_name'=> $data['title'],
                            'cwf_fltrvlu_order' => count($results_count) + 1 ,
                            'cwf_fltrvlu_status' => $data['status'],
                            'cwf_fltrvlu_fltr_id' => $_GET['filter'],
                            'cwf_fltrvlu_active' => '1',
                            'cwf_fltrvlu_created_at' => date("Y-m-d h:i:s"),
                            'cwf_fltrvlu_created_ip' => $this->request->getIPAddress(),
                            'cwf_fltrvlu_created_id' => dsession_id(),
                            'cwf_fltrvlu_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_fltrvlu_updated_id' => dsession_id(),
                            'cwf_fltrvlu_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration Successful");
            return $this->response->redirect(current_url().'?filter='.$_GET['filter']);
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?filter='.$_GET['filter']);
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = dbconnect('cwf_filters_value');
        $data['cat_data'] = (array) $db->where('cwf_fltrvlu_active','A')->where('cwf_fltrvlu_hash', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Cwf/filters-options/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = dbconnect('cwf_filters_value');


        $save_data = array(
                            'cwf_fltrvlu_name'=> $data['title'],
                            'cwf_fltrvlu_status' => $data['status'],
                            'cwf_fltrvlu_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_fltrvlu_updated_id' => dsession_id(),
                            'cwf_fltrvlu_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('cwf_fltrvlu_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url().'?filter='.$_GET['filter']);
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?filter='.$_GET['filter']);
        }

    }

}

