<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class CountryController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = dbconnect('country');
        $data['list'] = $db->where('country_active','A')->orderby('country_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/country/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Cwf/country/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = dbconnect('country');

           
            $results = $db->where('country_name', $data['title'])->where('country_active','1')->get()->getResult();
            $results_count = $db->get()->getResult();

            if($results)
            {
                session()->setFlashdata("error", "Data Not Unique");
                return $this->response->redirect(current_url());
            }

            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
            }

        $save_data = array(
                            'country_name'=> $data['title'],
                            'country_order' => count($results_count) + 1 ,
                            'country_status' => $data['status'],
                            'country_iso' => $data['iso'],
                            'country_phonecode' => $data['phone_code'],
                            'country_active' => 'A',
                            'country_created_at' => date("Y-m-d h:i:s"),
                            'country_created_ip' => $this->request->getIPAddress(),
                            'country_created_id' => dsession_id(),
                            'country_updated_ip'  => $this->request->getIPAddress(),
                            'country_updated_id' => dsession_id(),
                            'country_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = dbconnect('country');
        $data['cat_data'] = (array) $db->where('country_active','A')->where('country_id', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Cwf/country/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = dbconnect('country');

        $save_data = array(
                            'country_iso' => $data['iso'],
                            'country_phonecode' => $data['phone_code'],
                            'country_name'=> $data['title'],
                            'country_status' => $data['status'],
                            'country_updated_ip'  => $this->request->getIPAddress(),
                            'country_updated_id' => dsession_id(),
                            'country_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->where('country_id', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

