<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class CategoryController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        if(!isset($_GET['parent']))
        {
            $db = \Config\Database::connect()->table('cwf_category');
            $data['list'] = $db->where('cwf_cat_active','A')->orderby('cwf_cat_order', 'ASC')->where('cwf_cat_parent_id', Null)->get()->getResult();
        }else
        {
             $data['list']  = getCwfCategoryListByID($_GET['parent']);
        }
       
        
        echo view('Admin/include/header');
        echo view('Cwf/category/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $db = dbconnect('cwf_filters');
        $data['filter_list'] = $db->where('cwf_fltr_active','1')->where('cwf_fltr_status','A')->orderby('cwf_fltr_order', 'ASC')->get()->getResult();
        
        
        $db = \Config\Database::connect()->table('cwf_category');
        $data['list'] = $db->where('cwf_cat_active','A')->orderby('cwf_cat_order', 'ASC')->get()->getResult();


        if(isset($_GET['page']))
        {
            if( $_GET['page'] == 'specialization')
            {
                $db = \Config\Database::connect()->table('cwf_specialization');
                $datas['list'] = $db->where('cwf_spe_active','1')->where('cwf_spe_status','A')->orderby('cwf_spe_order', 'ASC')->get()->getResult();
                echo view('Admin/include/header');
                echo view('Cwf/category/specialization', $datas);
                echo view('Admin/include/footer');
            }elseif($_GET['page'] == 'attr_category')
            {
                $db = \Config\Database::connect()->table('cwf_attribute_category');
                $datas['list'] = $db->where('cwf_attr_cat_active','A')->where('cwf_attr_cat_status','A')->orderby('cwf_attr_cat_order', 'ASC')->get()->getResult();
                echo view('Admin/include/header');
                echo view('Cwf/category/arrt_cat', $datas);
                echo view('Admin/include/footer');
            }elseif($_GET['page'] == 'features')
            {
                $db = dbconnect('cwf_features');
                $datas['list'] = $db->where('cwff_active','1')->where('cwff_status','A')->orderby('cwff_order', 'ASC')->get()->getResult();
                echo view('Admin/include/header');
                echo view('Cwf/category/features', $datas);
                echo view('Admin/include/footer');
            }elseif($_GET['page'] == 'dimensions')
            {
                $db = dbconnect('cwf_dimensions');
                $datas['list'] = $db->where('cwf_dim_active','1')->where('cwf_dim_status','A')->orderby('cwf_dim_order', 'ASC')->get()->getResult();
                echo view('Admin/include/header');
                echo view('Cwf/category/dimensions', $datas);
                echo view('Admin/include/footer');
            }elseif($_GET['page'] == 'technical-information')
            {
                $db = dbconnect('cwf_tech_info');
                $datas['list'] = $db->where('cwf_ti_active','1')->where('cwf_ti_status','A')->orderby('cwf_ti_order', 'ASC')->get()->getResult();
                echo view('Admin/include/header');
                echo view('Cwf/category/technical-information', $datas);
                echo view('Admin/include/footer');
            }elseif($_GET['page'] == 'banner-images')
            {
                $db = dbconnect('cwf_cat_banner_images');
                $datas['list'] = $db->where('cwfcbi_active','A')->where('cwfcbi_cat_id', $_GET['id'])->orderby('cwfcbi_order', 'ASC')->get()->getResult();
                echo view('Admin/include/header');
                echo view('Cwf/category/cat-banner-images', $datas);
                echo view('Admin/include/footer');
            }else
            {

            }
        }else
        {
            echo view('Admin/include/header');
            echo view('Cwf/category/add', $data);
            echo view('Admin/include/footer');
        }

        
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_category');

            if($data['parent_category'])
            {
                $results = $db->where('cwf_cat_name', $data['title'])->where('cwf_cat_parent_id', $data['parent_category'])->get()->getResult();
            }else
            {
                $results = $db->where('cwf_cat_name', $data['title'])->get()->getResult();
            }

            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', ltrim($data['title']))));
            


            // $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            // $results = $db->where('cwf_cat_name', $data['title'])->get()->getResult();
            $results_count = $db->get()->getResult();

            // if($results)
            // {
            //     session()->setFlashdata("error", "Category Not Unique");
            //     return $this->response->redirect(current_url());
            // }

            // if($results)
            // {
            //     $count_result = count($results);
            //     $count_result = $count_result + 1;
            //     $slug = $slug.'-'.$count_result;
            // }
             if($results)
            {
                
                $count_result = count($results);
                    $count_result = $count_result -1;
                    $slug = $slug.'-'.$count_result +1;
                
           
            }

        $save_data = array(
                            'cwf_cat_hash'=> createHash(),
                            'cwf_cat_name'=> ltrim($data['title']),
                            'cwf_cat_slug'=> $slug,
                            'cwf_cat_order' => count($results_count) + 1 ,
                            'cwf_cat_description'=> $data['description'],
                            'cwf_cat_status' => $data['status'],
                            'cwf_cat_active' => 'A',
                            'cwf_cat_created_at' => date("Y-m-d h:i:s"),
                            'cwf_cat_created_ip' => $this->request->getIPAddress(),
                            'cwf_cat_created_id' => dsession_id(),
                            'cwf_cat_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_cat_updated_id' => dsession_id(),
                            'cwf_cat_updated_at' => date("Y-m-d h:i:s"),
                        );

        if(isset($data['filters']))
        {
            $save_data['cwf_cat_filters'] = implode(',',$data['filters']);
        }



        if($data['parent_category'])
        {
            $save_data['cwf_cat_parent_id'] = $data['parent_category'];
        }

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $db = dbconnect('cwf_filters');
        $data['filter_list'] = $db->where('cwf_fltr_active','1')->where('cwf_fltr_status','A')->orderby('cwf_fltr_order', 'ASC')->get()->getResult();
        
        $token = $this->request->getGet('token');

        $db = \Config\Database::connect()->table('cwf_category');
        $data['cat_data'] = $db->where('cwf_cat_active','A')->where('cwf_cat_hash', $token)->get()->getRow();
        $data['cat_data'] = (array) $data['cat_data'];


        $db = \Config\Database::connect()->table('cwf_category');
        $data['list'] = $db->where('cwf_cat_active','A')->orderby('cwf_cat_order', 'ASC')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Cwf/category/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_category');


        $save_data = array(
                            'cwf_cat_name'=> ltrim($data['title']),
                            'cwf_cat_slug'=> ltrim($data['slug']),
                            'cwf_cat_description'=> $data['description'],
                            'cwf_cat_status' => $data['status'],
                            'cwf_cat_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_cat_updated_id' => dsession_id(),
                            'cwf_cat_updated_at' => date("Y-m-d h:i:s"),
                        );
        
        if(isset($data['filters']))
        {
            $save_data['cwf_cat_filters'] = implode(',',$data['filters']);
        }else
        {
            $save_data['cwf_cat_filters'] = '';
        }
        
        if($data['parent_category'])
        {
            $save_data['cwf_cat_parent_id'] = $data['parent_category'];
        }
        
        
        if($data['token'] == 'e5cf5ab03ccd0f4717574081532bd3bebec07ded16767e76202e42b8bdcaff3c')
        {
            session()->setFlashdata("error", "Edit Not allowed");
            return $this->response->redirect(current_url());
        }
            
        
        if($db->where('cwf_cat_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

















// Upload Banner Images

    public function uploadBannerImages()
    {
        $data = $this->request->getVar();

        

        $db = dbconnect('cwf_cat_banner_images');
        $path = './uploads/images/category-images/'.$data['id'];

        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }

        $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[image/jpg,image/jpeg,image/gif,image/png,image/webp]',
                    'max_size[file,1024]',
                ],
            ]);


        $avatar = $this->request->getFile('file');
        $file_name =  $avatar->getName();
        $ext = $avatar->getClientExtension();




         $name = str_replace('.'.$ext,'-', $file_name);
         $name = str_replace(' ','-', $name);

         if(empty($data['title']))
         {
            $imageName = str_replace('.'.$ext,'', $file_name);
        }else
        {
           $imageName = $data['title'];
        }

         

         // echo "<pre>";
         // print_r($imageName);
         // echo "</pre>";
         // exit();

         $final_name = $data['id'].'-'.$name.getDate()[0].'.'.$ext;

        $avatar->move($path, $final_name);

        $results_count = $db->where('cwfcbi_cat_id', $data['id'])->where('cwfcbi_active', 'A')->get()->getResult();

        $save_data = array(
                            'cwfcbi_hash'=> createHash(),
                            'cwfcbi_name'=> $imageName,
                            'cwfcbi_cat_id' => $data['id'],
                            'cwfcbi_image' => $final_name,
                            'cwfcbi_order' => count($results_count) + 1 ,
                            'cwfcbi_status' => 'A',
                            'cwfcbi_active' => 'A',
                            'cwfcbi_created_at' => date("Y-m-d h:i:s"),
                            'cwfcbi_created_ip' => $this->request->getIPAddress(),
                            'cwfcbi_created_id' => dsession_id(),
                            'cwfcbi_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcbi_updated_id' => dsession_id(),
                            'cwfcbi_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Image Uploaded.");
            return $this->response->redirect(site_url('admin/master-category?action=create&page=banner-images&id='.$data['id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(site_url('admin/master-category?action=create&page=banner-images&id='.$data['id']));
        }
    }


    public function editBannerImage()
    {
        $datainput = $this->request->getVar();
        $db = dbconnect('cwf_cat_banner_images');

        $datas['details'] = $db->where('cwfcbi_active', 'A')->where('cwfcbi_hash', $datainput['token'])->get()->getRow();


        

        echo view('Admin/include/header');
        echo view('Cwf/category/cat-banner-images-edit', $datas);
        echo view('Admin/include/footer');
    }


    public function editBannerImageConf()
    {
        $data = $this->request->getVar();
        $db = dbconnect('cwf_cat_banner_images');

        if($_FILES['file']['name'])
        {  
            // Image
            $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[file,image/jpg,image/jpeg,image/gif,image/png,image/webp]',
                    'max_size[file,1024]',
                ],
            ]);

            $path = './uploads/images/category-images/'.$data['id'];

            if(!$validated) {
                session()->setFlashdata("error", "Please Upload Valid File");
                return $this->response->redirect(current_url().'?token='.$data['token'].'&id='.$data['id']);
            }

            $avatar = $this->request->getFile('file');
            $file_name =  $avatar->getName();
            $ext = $avatar->getClientExtension();
            $name = str_replace('.'.$ext,'-', $file_name);
            $name = str_replace(' ','-', $name);
            $final_name = $data['id'].'-'.$name.getDate()[0].'.'.$ext;
            $avatar->move($path, $final_name);

        }else
        {
            $final_name = '';
        }


        $save_data = array(
                            'cwfcbi_name'=> $data['title'],
                            'cwfcbi_status' => $data['status'],
                            'cwfcbi_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcbi_updated_id' => dsession_id(),
                            'cwfcbi_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($final_name)
        {
            $save_data['cwfcbi_image'] = $final_name;
        }

        if($db->where('cwfcbi_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Image Updated");
             return $this->response->redirect(current_url().'?token='.$data['token'].'&id='.$data['id']);
        }else{
            session()->setFlashdata("error", "Somting went wrong, please try again!");
             return $this->response->redirect(current_url().'?token='.$data['token'].'&id='.$data['id']);
        }
    }


















    // 

    public function getSpecializationList()
    {
        $db = dbconnect('cwf_cat_specialization');
        $data['list'] = $db->join('cwf_category', 'cwfcs_cat_id = cwf_category.cwf_cat_id')->join('cwf_specialization', 'cwfcs_specialization_id = cwf_specialization.cwf_spe_id')->where('cwfcs_cat_id', $_GET['id'])->where('cwfcs_active', 'A')->orderby('cwfcs_order', 'ASC')->get()->getResult();
        echo view('Cwf/category/specialization_list', $data);
    }

    public function getFeaturesList()
    {
        $db = dbconnect('cwf_cat_features');
        $data['list'] = $db->join('cwf_category', 'cwfcf_cat_id = cwf_category.cwf_cat_id')->join('cwf_features', 'cwfcf_features_id = cwf_features.cwff_id')->where('cwfcf_cat_id', $_GET['id'])->where('cwfcf_active', 'A')->orderby('cwfcf_order', 'ASC')->get()->getResult();
        echo view('Cwf/category/features_list', $data);
    }

    public function getAttrCatList()
    {
        $db = dbconnect('cwf_cat_attribute_category');
        $data['list'] = $db->join('cwf_category', 'cwfcac_cat_id = cwf_category.cwf_cat_id')->join('cwf_attribute_category', 'cwfcac_attr_cat_id = cwf_attribute_category.cwf_attr_cat_id')->where('cwfcac_cat_id', $_GET['id'])->where('cwfcac_active', 'A')->orderby('cwfcac_order', 'ASC')->get()->getResult();
        echo view('Cwf/category/arrt_cat_list', $data);
    }


    public function getDimensionsList()
    {
        $db = dbconnect('cwf_cat_dimensions');
        $data['list'] = $db->join('cwf_category', 'cwfcd_cat_id = cwf_category.cwf_cat_id')->join('cwf_dimensions', 'cwfcd_dimensions_id = cwf_dimensions.cwf_dim_id')->where('cwfcd_cat_id', $_GET['id'])->where('cwfcd_active', 'A')->orderby('cwfcd_order', 'ASC')->get()->getResult();
        echo view('Cwf/category/dimensions_list', $data);
    }

    public function getTechInfoList()
    {
        $db = dbconnect('cwf_cat_tech_info');
        $data['list'] = $db->join('cwf_category', 'cwfcti_cat_id = cwf_category.cwf_cat_id')->join('cwf_tech_info', 'cwfcti_tech_info_id = cwf_tech_info.cwf_ti_id')->where('cwfcti_cat_id', $_GET['id'])->where('cwfcti_active', 'A')->orderby('cwfcti_order', 'ASC')->get()->getResult();
        echo view('Cwf/category/technical-information_list', $data);
    }











    public function addSpecializationList()
    {
        $data = $this->request->getVar();

        $db = dbconnect('cwf_cat_specialization');
        $results_count = $db->join('cwf_category', 'cwfcs_cat_id = cwf_category.cwf_cat_id')->join('cwf_specialization', 'cwfcs_specialization_id = cwf_specialization.cwf_spe_id')->where('cwfcs_cat_id', $data['cat_id'])->where('cwfcs_active', 'A')->orderby('cwfcs_order', 'ASC')->get()->getResult();


        $re_results_count = $db->join('cwf_category', 'cwfcs_cat_id = cwf_category.cwf_cat_id')->join('cwf_specialization', 'cwfcs_specialization_id = cwf_specialization.cwf_spe_id')->where('cwfcs_specialization_id', $data['spec_id'])->where('cwfcs_cat_id', $data['cat_id'])->where('cwfcs_active', 'A')->orderby('cwfcs_order', 'ASC')->get()->getResult();

        if ($re_results_count) {
            echo '0';
            exit();
        }

        $save_data = array(
                            'cwfcs_hash'=> createHash(),
                            'cwfcs_specialization_id'=> $data['spec_id'],
                            'cwfcs_order' => count($results_count) + 1 ,
                            'cwfcs_cat_id'=> $data['cat_id'],
                            'cwfcs_status' => 'A',
                            'cwfcs_active' => 'A',
                            'cwfcs_created_at' => date("Y-m-d h:i:s"),
                            'cwfcs_created_ip' => $this->request->getIPAddress(),
                            'cwfcs_created_id' => dsession_id(),
                            'cwfcs_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcs_updated_id' => dsession_id(),
                            'cwfcs_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->insert($save_data))
        {
            echo '1';
        }else
        {
            echo '0';
        }

    }


    public function addFeaturesList()
    {
        $data = $this->request->getVar();


        $db = dbconnect('cwf_cat_features');
        $results_count = $db->join('cwf_category', 'cwfcf_cat_id = cwf_category.cwf_cat_id')->join('cwf_features', 'cwfcf_features_id = cwf_features.cwff_id')->where('cwfcf_cat_id', $data['cat_id'])->where('cwfcf_active', 'A')->orderby('cwfcf_order', 'ASC')->get()->getResult();


        $re_results_count = $db->join('cwf_category', 'cwfcf_cat_id = cwf_category.cwf_cat_id')->join('cwf_features', 'cwfcf_features_id = cwf_features.cwff_id')->where('cwfcf_features_id', $data['spec_id'])->where('cwfcf_cat_id', $data['cat_id'])->where('cwfcf_active', 'A')->orderby('cwfcf_order', 'ASC')->get()->getResult();

        if ($re_results_count) {
            echo '0';
            exit();
        }

        $save_data = array(
                            'cwfcf_hash'=> createHash(),
                            'cwfcf_features_id'=> $data['spec_id'],
                            'cwfcf_order' => count($results_count) + 1 ,
                            'cwfcf_cat_id'=> $data['cat_id'],
                            'cwfcf_status' => 'A',
                            'cwfcf_active' => 'A',
                            'cwfcf_created_at' => date("Y-m-d h:i:s"),
                            'cwfcf_created_ip' => $this->request->getIPAddress(),
                            'cwfcf_created_id' => dsession_id(),
                            'cwfcf_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcf_updated_id' => dsession_id(),
                            'cwfcf_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->insert($save_data))
        {
            echo '1';
        }else
        {
            echo '0';
        }

    }

    public function addAttrCatList()
    {
        $data = $this->request->getVar();

        $db = dbconnect('cwf_cat_attribute_category');

        $results_count = $db->join('cwf_category', 'cwfcac_cat_id = cwf_category.cwf_cat_id')->join('cwf_attribute_category', 'cwfcac_attr_cat_id = cwf_attribute_category.cwf_attr_cat_id')->where('cwfcac_cat_id', $data['cat_id'])->where('cwfcac_active', 'A')->orderby('cwfcac_order', 'ASC')->get()->getResult();

        $re_results_count = $db->join('cwf_category', 'cwfcac_cat_id = cwf_category.cwf_cat_id')->join('cwf_attribute_category', 'cwfcac_attr_cat_id = cwf_attribute_category.cwf_attr_cat_id')->where('cwfcac_cat_id', $data['cat_id'])->where('cwfcac_attr_cat_id', $data['spec_id'])->where('cwfcac_active', 'A')->orderby('cwfcac_order', 'ASC')->get()->getResult();


        


        if ($re_results_count) {
            echo '0';
            exit();
        }

        $save_data = array(
                            'cwfcac_hash'=> createHash(),
                            'cwfcac_attr_cat_id'=> $data['spec_id'],
                            'cwfcac_order' => count($results_count) + 1 ,
                            'cwfcac_cat_id'=> $data['cat_id'],
                            'cwfcac_status' => 'A',
                            'cwfcac_active' => 'A',
                            'cwfcac_created_at' => date("Y-m-d h:i:s"),
                            'cwfcac_created_ip' => $this->request->getIPAddress(),
                            'cwfcac_created_id' => dsession_id(),
                            'cwfcac_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcac_updated_id' => dsession_id(),
                            'cwfcac_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->insert($save_data))
        {
            echo '1';
        }else
        {
            echo '0';
        }

    }


    public function addDimensionsList()
    {
        $data = $this->request->getVar();


        $db = dbconnect('cwf_cat_dimensions');
        $results_count = $db->join('cwf_category', 'cwfcd_cat_id = cwf_category.cwf_cat_id')->join('cwf_dimensions', 'cwfcd_dimensions_id = cwf_dimensions.cwf_dim_id')->where('cwfcd_cat_id', $data['cat_id'])->where('cwfcd_active', 'A')->orderby('cwfcd_order', 'ASC')->get()->getResult();


        $re_results_count = $db->join('cwf_category', 'cwfcd_cat_id = cwf_category.cwf_cat_id')->join('cwf_dimensions', 'cwfcd_dimensions_id = cwf_dimensions.cwf_dim_id')->where('cwfcd_dimensions_id', $data['spec_id'])->where('cwfcd_cat_id', $data['cat_id'])->where('cwfcd_active', 'A')->orderby('cwfcd_order', 'ASC')->get()->getResult();

        if ($re_results_count) {
            echo '0';
            exit();
        }

        $save_data = array(
                            'cwfcd_hash'=> createHash(),
                            'cwfcd_dimensions_id'=> $data['spec_id'],
                            'cwfcd_order' => count($results_count) + 1 ,
                            'cwfcd_cat_id'=> $data['cat_id'],
                            'cwfcd_status' => 'A',
                            'cwfcd_active' => 'A',
                            'cwfcd_created_at' => date("Y-m-d h:i:s"),
                            'cwfcd_created_ip' => $this->request->getIPAddress(),
                            'cwfcd_created_id' => dsession_id(),
                            'cwfcd_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcd_updated_id' => dsession_id(),
                            'cwfcd_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->insert($save_data))
        {
            echo '1';
        }else
        {
            echo '0';
        }

    }

    public function addTechInfoList()
    {
        $data = $this->request->getVar();


        $db = dbconnect('cwf_cat_tech_info');
        $results_count = $db->join('cwf_category', 'cwfcti_cat_id = cwf_category.cwf_cat_id')->join('cwf_tech_info', 'cwfcti_tech_info_id = cwf_tech_info.cwf_ti_id')->where('cwfcti_cat_id', $data['cat_id'])->where('cwfcti_active', 'A')->orderby('cwfcti_order', 'ASC')->get()->getResult();


        $re_results_count = $db->join('cwf_category', 'cwfcti_cat_id = cwf_category.cwf_cat_id')->join('cwf_tech_info', 'cwfcti_tech_info_id = cwf_tech_info.cwf_ti_id')->where('cwfcti_tech_info_id', $data['spec_id'])->where('cwfcti_cat_id', $data['cat_id'])->where('cwfcti_active', 'A')->orderby('cwfcti_order', 'ASC')->get()->getResult();

        if ($re_results_count) {
            echo '0';
            exit();
        }

        $save_data = array(
                            'cwfcti_hash'=> createHash(),
                            'cwfcti_tech_info_id'=> $data['spec_id'],
                            'cwfcti_order' => count($results_count) + 1 ,
                            'cwfcti_cat_id'=> $data['cat_id'],
                            'cwfcti_status' => 'A',
                            'cwfcti_active' => 'A',
                            'cwfcti_created_at' => date("Y-m-d h:i:s"),
                            'cwfcti_created_ip' => $this->request->getIPAddress(),
                            'cwfcti_created_id' => dsession_id(),
                            'cwfcti_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcti_updated_id' => dsession_id(),
                            'cwfcti_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->insert($save_data))
        {
            echo '1';
        }else
        {
            echo '0';
        }

    }










    public function deleteSpecializationList()
    {
        $db = dbconnect('cwf_cat_specialization');
        $save_data = array(
                            'cwfcs_active' => 'D',
                            'cwfcs_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcs_updated_id' => dsession_id(),
                            'cwfcs_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->where('cwfcs_hash', $_GET['token'])->set($save_data)->update())
        {
            echo '1';
        }else
        {
            echo '0';
        }
    }

    public function deleteFeaturesList()
    {
        $db = dbconnect('cwf_cat_features');
        $save_data = array(
                            'cwfcf_active' => 'D',
                            'cwfcf_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcf_updated_id' => dsession_id(),
                            'cwfcf_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->where('cwfcf_hash', $_GET['token'])->set($save_data)->update())
        {
            echo '1';
        }else
        {
            echo '0';
        }
    }


    public function deleteAttrCatList()
    {
        $db = dbconnect('cwf_cat_attribute_category');
        $save_data = array(
                            'cwfcac_active' => 'D',
                            'cwfcac_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcac_updated_id' => dsession_id(),
                            'cwfcac_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->where('cwfcac_hash', $_GET['token'])->set($save_data)->update())
        {
            echo '1';
        }else
        {
            echo '0';
        }
    }

    public function deleteDimensionsList()
    {
        $db = dbconnect('cwf_cat_dimensions');
        $save_data = array(
                            'cwfcd_active' => 'D',
                            'cwfcd_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcd_updated_id' => dsession_id(),
                            'cwfcd_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->where('cwfcd_hash', $_GET['token'])->set($save_data)->update())
        {
            echo '1';
        }else
        {
            echo '0';
        }
    }


    public function deleteTechInfoList()
    {
        $db = dbconnect('cwf_cat_tech_info');
        $save_data = array(
                            'cwfcti_active' => 'D',
                            'cwfcti_updated_ip'  => $this->request->getIPAddress(),
                            'cwfcti_updated_id' => dsession_id(),
                            'cwfcti_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->where('cwfcti_hash', $_GET['token'])->set($save_data)->update())
        {
            echo '1';
        }else
        {
            echo '0';
        }
    }





















}

