<?php

namespace App\Controllers;

class CategoryController extends BaseController
{
    public function index($slug)
    {
    	$db = dbconnect('cwf_category');
    	$catData = $db->where('cwf_cat_slug', $slug)->where('cwf_cat_status', 'A')->where('cwf_cat_active', 'A')->get()->getRow();

    	

    	$data['cat'] = $catData;
    	$data['page_details'] = ['slug' => $slug, 'cat_id' => $catData->cwf_cat_id];

    	// echo "<pre>";
    	// print_r($data);
    	// exit();

		$db = dbconnect('cwf_products');
		$data['list'] = $db->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->where('cwf_cat_parent_id', $catData->cwf_cat_id)->get()->getResult();

		$db =dbconnect('cwf_color');
        $data['color_list'] = $db->where('cwfc_active','A')->where('cwfc_status','A')->orderby('cwfc_order', 'ASC')->get()->getResult();

        $db =dbconnect('cwf_filters');
        $data['filter_list'] = $db->whereIn('cwf_fltr_id', explode(',', $catData->cwf_cat_filters))->where('cwf_fltr_active','1')->where('cwf_fltr_status','A')->orderby('cwf_fltr_order', 'ASC')->get()->getResult();

		echo view('public/category/list', $data);

    }




    public function ajaxIndex($slug)
    {
    	$db = dbconnect('cwf_category');


    	$catData = $db->where('cwf_cat_slug', $slug)->where('cwf_cat_status', 'A')->where('cwf_cat_active', 'A')->get()->getRow();

    	

    	$data['cat'] = $catData;
    	$data['page_details'] = ['slug' => $slug, 'cat_id' => $catData->cwf_cat_id];



    	if(isset($_SESSION['filter']) AND (count($_SESSION['filter']) >= 1))
    	{
    		$db = dbconnect('cwf_prod_color');
        	$data['list'] = $db->select('cwfpc_product_id, pro_slug, pro_main_image, pro_id, pro_title, pro_subtitle')->distinct()->whereIn('cwfpc_color_id', $_SESSION['filter'])->join('cwf_products', 'cwfpc_product_id = cwf_products.pro_id')->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->where('cwf_cat_parent_id', $catData->cwf_cat_id)->where('pro_active', 'A')->where('cwfpc_status', 'A')->where('cwfpc_active', 'A')->limit(9, 0)->get()->getResult();
    	}else
    	{
    		$db = dbconnect('cwf_products');
			$data['list'] = $db->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->where('cwf_cat_parent_id', $catData->cwf_cat_id)->limit(9, 0)->get()->getResult();

    	}

    	// echo '<pre>';
    	// print_r($data['list']);
    	// exit();

		
		
		echo view('public/category/ajax_product_list', $data);
    }


    public function ajaxIndexwithPagination($slug)
    {
    	// ->limit(10, 20);
    	 // 10 = per page, 20 = statrting index

    	if(isset($_GET['page']))
    	{
    		$page_id = $_GET['page'];
    	}else
    	{
    		$page_id = 1;
    	}

    	
    	$start_number = $page_id*9 - 9;


    	$db = dbconnect('cwf_category');

    	$catData = $db->where('cwf_cat_slug', $slug)->where('cwf_cat_status', 'A')->where('cwf_cat_active', 'A')->get()->getRow();



    	$data['cat'] = $catData;
    	$data['page_details'] = ['slug' => $slug, 'cat_id' => $catData->cwf_cat_id];

    	if(isset($_SESSION['filter']) AND (count($_SESSION['filter']) >= 1))
    	{
    		$db = dbconnect('cwf_prod_color');
        	$data['list'] = $db->select('cwfpc_product_id, pro_slug, pro_main_image, pro_id, pro_title, pro_subtitle')->distinct()->whereIn('cwfpc_color_id', $_SESSION['filter'])->join('cwf_products', 'cwfpc_product_id = cwf_products.pro_id')->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->where('cwf_cat_parent_id', $catData->cwf_cat_id)->where('pro_active', 'A')->where('cwfpc_status', 'A')->where('cwfpc_active', 'A')->limit(9, $start_number)->get()->getResult();
    	}else
    	{
    		$db = dbconnect('cwf_products');
			$data['list'] = $db->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->limit(9, $start_number)->where('cwf_cat_parent_id', $catData->cwf_cat_id)->limit(9, $start_number)->get()->getResult();

    	}

		$list_data = view('public/category/pager_list', $data);
		$page_id = $_GET['page']+1;

		echo json_encode(['data'=> $list_data, 'page_number' => $page_id]);

    }

  
}
