<?php 
namespace App\Controllers;
use App\Models\CountryModel;
use App\Models\StateModel;
use App\Models\CityModel;
use App\Models\DistrictModel;
use App\Models\GenderModel;
use App\Models\PostModel;
use App\Models\PageModel;
use App\Controllers\BaseController;

class Ajax extends BaseController
{

	public function index()
	{
        echo "Null";   
	}

    // Get All Gender
    public function genders()
    {
        $genders = new GenderModel();
        $dyanmicData['genders'] = $genders->orderBy('gender_name', 'ASC')->where('gender_active','A')->findAll();

        echo "<pre>";
        print_r($dyanmicData['genders']);
    }

    // Get All Country
    public function countrys()
    {
        $countrys = new CountryModel();
        $dyanmicData['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();

        echo "<pre>";
        print_r($dyanmicData['countrys']);
    }

    // Get State List By Country Id
    public function stateByCountryId()
    {
        $country_id = $parent_id = $this->request->getGet('country_id');
        $states = new StateModel();
        $state = $states->orderBy('state_title', 'ASC')->where(['state_active'=>'A', 'sate_country_id'=>$country_id])->findAll();

        echo '<option value="">Select</option>';
        foreach ($state as $row) {
            echo '<option value='.$row['state_id'].'>'.$row['state_title'].'</option>';
        }
    }

    // Get district List By State Id
    public function districtByStateId()
    {
        $state_id = $parent_id = $this->request->getGet('state_id');
        $districts = new DistrictModel();
        $dyanmicData['districts'] = $districts->orderBy('district_title', 'ASC')->where(['district_active'=>'A', 'district_state_id'=>$state_id])->findAll();

        echo "<pre>";
        print_r($dyanmicData['districts']);
    }


    // Get City List By State Id
    public function cityByStateId()
    {
        $state_id = $parent_id = $this->request->getGet('state_id');
        $citys = new CityModel();
        $dyanmicData['citys'] = $citys->orderBy('city_name', 'ASC')->where(['city_active'=>'A', 'city_state_id'=>$state_id])->findAll();

        echo '<option value="">Select</option>';
        foreach ($dyanmicData['citys'] as $row) {
            echo '<option value='.$row['city_id'].'>'.$row['city_name'].'</option>';
        }
    }


    // Post Image Upload
    public function upload_post_featured_image()
    {
        $data = $this->request->getVar();
        
        $data['token'] = $_GET['token'];

        $post = new PostModel();

        $validated = $this->validate([
            'file' => [
                'uploaded[file]',
                'mime_in[file,image/jpg,image/jpeg,image/gif,image/png]',
                'max_size[file,4096]',
            ],
        ]);
 
       
  
        if($validated) {
            $avatar = $this->request->getFile('file');
            $newName = $avatar->getRandomName();
            $avatar->move('./uploads/media/', $newName);
 
            $save_data = [
                'post_featured_image'=> $newName,
                'post_updated_id' => dsession_id(),
                'post_updated_at' => date("Y-m-d h:i:s")
            ];

            

            if($post->where('post_hash', $data['token'])->set($save_data)->update())
            {
                $response = [
                    'success' => true,
                    'data' => site_url('uploads/media/'.$newName),
                    'msg' => "Image successfully uploaded"
                ];
            }else
            {
                $response = [
                    'success' => false,
                    'data' => '',
                    'msg' => "Image could not upload"
                ];
            }

        }else{
            $response = [
                'success' => false,
                'data' => '',
                'msg' => "Image could not upload Validation error"
            ];
        }
        
        echo json_encode($response);
    }


    // Post Content Live Update

    public function ajaxUpdatePostPreviewContent()
    {
        $hash_id = $this->request->getVar('token');
        $content = $this->request->getVar('content');
        $post = new PostModel();
        $udata = [
                    'post_content_live_preview' => $content,
                    'post_updated_id' => dsession_id(),
                    'post_updated_at' => date("Y-m-d h:i:s"),
                ];

        if($post->where('post_hash', $hash_id)->set($udata)->update())
        {
           $response = array(
                                'token' => $hash_id,
                                'content' => $content,
                            );
           echo json_encode($response);
        }else
        {
            $response = ['error'=>'Updating Faild'];
            echo json_encode($response);
        } 

    }




    // Post Image Upload
    public function upload_page_featured_image()
    {
        $data = $this->request->getVar();
        
        $data['token'] = $_GET['token'];

        $post = new PageModel();

        $validated = $this->validate([
            'file' => [
                'uploaded[file]',
                'mime_in[file,image/jpg,image/jpeg,image/gif,image/png]',
                'max_size[file,4096]',
            ],
        ]);
 
       
  
        if($validated) {
            $avatar = $this->request->getFile('file');
            $newName = $avatar->getRandomName();
            $avatar->move('./uploads/media/', $newName);
 
            $save_data = [
                'page_featured_image'=> $newName,
                'page_updated_id' => dsession_id(),
                'page_updated_at' => date("Y-m-d h:i:s")
            ];

            

            if($post->where('page_hash', $data['token'])->set($save_data)->update())
            {
                $response = [
                    'success' => true,
                    'data' => site_url('uploads/media/'.$newName),
                    'msg' => "Image successfully uploaded"
                ];
            }else
            {
                $response = [
                    'success' => false,
                    'data' => '',
                    'msg' => "Image could not upload"
                ];
            }

        }else{
            $response = [
                'success' => false,
                'data' => '',
                'msg' => "Image could not upload Validation error"
            ];
        }
        
        echo json_encode($response);
    }

    





}

