<?php 
namespace App\Controllers\Admin;
use App\Controllers\BaseController;

class TestimonialController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('testimonials');
        $data['list'] = $db->where('tstmnl_active','A')->orderby('tstmnl_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Admin/testimonial/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Admin/testimonial/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('testimonials');

            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $db->where('tstmnl_name', $data['name'])->get()->getResult();
            $results_count = $db->get()->getResult();
            // $results2 = $db->where('tstmnl_title', $data['title'])->get()->getResult();
            
            // if($results)
            // {
            //     session()->setFlashdata("error", "Data Not Unique");
            //     return $this->response->redirect(current_url());
            // }

        if($_FILES['file']['name'])
        {  
            // Image
            $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[file,image/jpg,image/jpeg,image/gif,image/png]',
                    'max_size[file,1024]',
                ],
            ]);
            if(!$validated) {
                session()->setFlashdata("error", "Please Upload Valid File");
                return $this->response->redirect(current_url()); 
            }

            $avatar = $this->request->getFile('file');
            $newName = $avatar->getRandomName();
            $avatar->move('./uploads/testimonials/', $newName);
        }else
        {
            $newName = '';
        }


        $save_data = array(
                            'tstmnl_hash'=> createHash(),
                            'tstmnl_name'=> $data['name'],
                            'tstmnl_image' => $newName,
                            'tstmnl_profession' => $data['profession'],
                            'tstmnl_title' => $data['title'],
                            'tstmnl_description' => $data['description'],
                            'tstmnl_order' => count($results_count) + 1 ,
                            'tstmnl_status' => $data['status'],
                            'tstmnl_active' => 'A',
                            'tstmnl_created_at' => date("Y-m-d h:i:s"),
                            'tstmnl_created_ip' => $this->request->getIPAddress(),
                            'tstmnl_created_id' => dsession_id(),
                            'tstmnl_updated_ip'  => $this->request->getIPAddress(),
                            'tstmnl_updated_id' => dsession_id(),
                            'tstmnl_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = \Config\Database::connect()->table('testimonials');
        $data['cat_data'] = (array) $db->where('tstmnl_active','A')->where('tstmnl_hash', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Admin/testimonial/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('testimonials');

        if($_FILES['file']['name'])
        {  
            // Image
            $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[file,image/jpg,image/jpeg,image/gif,image/png]',
                    'max_size[file,1024]',
                ],
            ]);
            if(!$validated) {
                session()->setFlashdata("error", "Please Upload Valid File");
                return $this->response->redirect(current_url()); 
            }

            $avatar = $this->request->getFile('file');
            $newName = $avatar->getRandomName();
            $avatar->move('./uploads/testimonials/', $newName);
        }else
        {
            $newName = '';
        }

        $save_data = array(
                            'tstmnl_name'=> $data['name'],
                            'tstmnl_profession' => $data['profession'],
                            'tstmnl_title' => $data['title'],
                            'tstmnl_description' => $data['description'],
                            'tstmnl_status' => $data['status'],
                            'tstmnl_updated_ip'  => $this->request->getIPAddress(),
                            'tstmnl_updated_id' => dsession_id(),
                            'tstmnl_updated_at' => date("Y-m-d h:i:s"),
                        );
        
        if($newName)
        {
            $save_data['tstmnl_image'] = $newName;
        }

        if($db->where('tstmnl_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}


?>


