<?php 
namespace App\Controllers\Admin;
use App\Models\PageModel;
use App\Models\CategoryModel;
use App\Models\TagModel;
use App\Controllers\BaseController;

class PageController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $list = new PageModel();
        $data['list'] = $list->where('page_active','A')->orderby('page_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/page/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $list = new PageModel();
        $data['list'] = $list->where('page_active','A')->orderby('page_id', 'DESC')->findAll();
        

        echo view('Admin/include/header');
        echo view('Admin/page/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $post = new PageModel();
        if($data['slug'])
        {
            $slug = $data['slug'];
        }else
        {
            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $post->where('page_title', $data['title'])->findAll();
            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $slug = $slug.'-'.$count_result;
            }
        }
        $save_data = array(
                            'page_hash'=> createHash(),
                            'page_title'=> $data['title'],
                            'page_slug'=> $slug,
                            'page_content'=> $data['description'],
                            'page_excerpt' => $data['excerpt'],
                            'page_status' => $data['status'],
                            'page_active' => 'A',
                            'page_created_ip' => $this->request->getIPAddress(),
                            'page_created_id' => dsession_id(),
                            'page_updated_ip'  => $this->request->getIPAddress(),
                            'page_updated_id' => dsession_id(),
                            'page_updated_at' => date("Y-m-d h:i:s"),
                        );


       

        if($post->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $list = new PageModel();
        $data['single_data'] = $list->where('page_active','A')->where('page_hash', $token)->first();
        $data['list'] = $list->where('page_active','A')->orderby('page_id', 'DESC')->findAll();

       
        echo view('Admin/include/header');
        echo view('Admin/page/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $post = new PageModel();

        if($data['slug'])
        {
            $slug = $data['slug'];
        }else
        {
            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $post->where('page_title', $data['title'])->findAll();
            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $slug = $slug.'-'.$count_result;
            }
        }

        $save_data = array(
                            'page_title'=> $data['title'],
                            'page_slug'=> $slug,
                            'page_content'=> $data['description'],
                            'page_excerpt' => $data['excerpt'],
                            'page_status' => $data['status'],
                            'page_updated_ip'  => $this->request->getIPAddress(),
                            'page_updated_id' => dsession_id(),
                            'page_updated_at' => date("Y-m-d h:i:s"),
                        );
       

        if($post->where('page_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }


    public function live_preview()
    {
        $token = $this->request->getGet('token');

        $post = new PageModel();
        $data['preview'] = $post->where('page_hash', $token)->first();

        echo view('template/header');
        echo view('template/preview', $data);
        echo view('template/footer');
    }



}

