<?php 
namespace App\Controllers\Admin;
use App\Models\AccountModel;
use App\Models\Admin_login_history;
use App\Controllers\BaseController;

class AdminController extends BaseController
{
	public function __construct() 
	{ 
		
	}

	// Login View
	public function index()
	{
		return view('Admin/login/index');
	}

	// Login Auth with Post Request
	public function auth()
	{
		$session = session();
        $account = new AccountModel();

        $accountData = $account->where('ac_email', $this->request->getVar('username'))->join('account_type','ac_type = account_type.at_id')->first();

        if(empty($accountData))
        {
        	$accountData = $account->where('ac_contact_no', $this->request->getVar('username'))->join('account_type','ac_type = account_type.at_id')->first();
        	if(empty($accountData))
        	{
        		session()->setFlashdata("error", "Invalid Username!");
                return $this->response->redirect(site_url(uri_string()));
        	}
        }


        if(!empty($accountData))
        {
        	if($accountData['ac_password'] == md5($this->request->getVar('password')))
        	{
        		$accountData['isLoggedIn'] = $accountData;
        		// echo "<pre>";
        		// print_r($accountData);
        		// exit();
        		
        		$session->set($accountData);
        		
        		$login_history = new Admin_login_history();
        		$login_data  = array(
        								'alh_admin_id' => $accountData['ac_id'],
        								'alh_login_ip' => $this->request->getIPAddress(),
        								'alh_login_at' => date("Y-m-d h:i:s"),
        								'alh_login_role' => $accountData['at_code'],
        								'alh_logout_at' => '', 
        							);
        		if($login_history->insert($login_data))
        		{
        			$login_history_id = $login_history->getInsertID();
        			$session->set('login_history_id',$login_history_id);
        			return $this->response->redirect(site_url('admin/dashboard'));
        		}
        	}else
        	{
        		session()->setFlashdata("error", "Password Not Matched, Please Try Again...");
            	return $this->response->redirect(site_url(uri_string()));
        	}
        }else
        {
        	session()->setFlashdata("error", "Somthing Went Wrong, Please Try Again...");
            return $this->response->redirect(site_url(uri_string()));
        }


	}

	public function redirect_login()
	{
		return $this->response->redirect(base_url('admin/login'));
	}


}

